package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.underlier.reports.UnderlyingAssetTradingPlatformIdentifierLeg1Rule;
import drr.standards.iosco.cde.underlier.reports.UnderlyingAssetTradingPlatformIdentifierLeg2Rule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UnderlyingAssetTradingPlatformIdentifierRule.UnderlyingAssetTradingPlatformIdentifierRuleDefault.class)
public abstract class UnderlyingAssetTradingPlatformIdentifierRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected UnderlyingAssetTradingPlatformIdentifierLeg1Rule underlyingAssetTradingPlatformIdentifierLeg1Rule;
	@Inject protected UnderlyingAssetTradingPlatformIdentifierLeg2Rule underlyingAssetTradingPlatformIdentifierLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingAssetTradingPlatformIdentifierRuleDefault extends UnderlyingAssetTradingPlatformIdentifierRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> {
					final String string0 = underlyingAssetTradingPlatformIdentifierLeg1Rule.evaluate(item.get());
					if ((string0 == null ? exists(MapperS.<FieldWithMetaString>ofNull()).getOrDefault(false) : exists(MapperS.of(FieldWithMetaString.builder().setValue(string0).build())).getOrDefault(false))) {
						final String string1 = underlyingAssetTradingPlatformIdentifierLeg1Rule.evaluate(item.get());
						return string1 == null ? MapperS.<FieldWithMetaString>ofNull() : MapperS.of(FieldWithMetaString.builder().setValue(string1).build());
					}
					final String string2 = underlyingAssetTradingPlatformIdentifierLeg2Rule.evaluate(item.get());
					return string2 == null ? MapperS.<FieldWithMetaString>ofNull() : MapperS.of(FieldWithMetaString.builder().setValue(string2).build());
				}).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
