package drr.regulation.hkma.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("HKMATransactionReportDOC0017")
@ImplementedBy(HKMATransactionReportDOC0017.Default.class)
public interface HKMATransactionReportDOC0017 extends Validator<HKMATransactionReport> {
	
	String NAME = "HKMATransactionReportDOC0017";
	String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and direction2Leg1 is absent and direction2Leg2 is absent then direction1 exists else if ((direction2Leg1 exists) or (direction2Leg2 exists)) then direction1 is absent";
	
	class Default implements HKMATransactionReportDOC0017 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
			ComparisonResult result = executeDataRule(hKMATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "HKMATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "HKMATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(HKMATransactionReport hKMATransactionReport) {
			try {
				if (areEqual(MapperC.<ActionTypeEnum>of(MapperS.of(ActionTypeEnum.NEWT), MapperS.of(ActionTypeEnum.MODI), MapperS.of(ActionTypeEnum.CORR), MapperS.of(ActionTypeEnum.REVI)), MapperS.of(hKMATransactionReport).<ActionTypeEnum>map("getActionType", _hKMATransactionReport -> _hKMATransactionReport.getActionType()), CardinalityOperator.Any).and(notExists(MapperS.of(hKMATransactionReport).<Direction2Enum>map("getDirection2Leg1", _hKMATransactionReport -> _hKMATransactionReport.getDirection2Leg1()))).and(notExists(MapperS.of(hKMATransactionReport).<Direction2Enum>map("getDirection2Leg2", _hKMATransactionReport -> _hKMATransactionReport.getDirection2Leg2()))).getOrDefault(false)) {
					return exists(MapperS.of(hKMATransactionReport).<Direction1Enum>map("getDirection1", _hKMATransactionReport -> _hKMATransactionReport.getDirection1()));
				}
				if (exists(MapperS.of(hKMATransactionReport).<Direction2Enum>map("getDirection2Leg1", _hKMATransactionReport -> _hKMATransactionReport.getDirection2Leg1())).or(exists(MapperS.of(hKMATransactionReport).<Direction2Enum>map("getDirection2Leg2", _hKMATransactionReport -> _hKMATransactionReport.getDirection2Leg2()))).getOrDefault(false)) {
					return notExists(MapperS.of(hKMATransactionReport).<Direction1Enum>map("getDirection1", _hKMATransactionReport -> _hKMATransactionReport.getDirection1()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements HKMATransactionReportDOC0017 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
			return Collections.emptyList();
		}
	}
}
