package drr.regulation.hkma.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport.HKMAValuationReportBuilder;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport.HKMAValuationReportBuilderImpl;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport.HKMAValuationReportImpl;
import drr.regulation.hkma.rewrite.valuation.meta.HKMAValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="HKMAValuationReport", builder=HKMAValuationReport.HKMAValuationReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="HKMAValuationReport", model="drr", builder=HKMAValuationReport.HKMAValuationReportBuilderImpl.class, version="6.0.0-dev.128")
public interface HKMAValuationReport extends RosettaModelObject {

	HKMAValuationReportMeta metaData = new HKMAValuationReportMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getCounterparty1();
	String getCounterparty2();
	String getCounterparty2Name();
	Boolean getCounterparty2IdentifierTypeIndicator();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ZonedDateTime getValuationTimestamp();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	ActionTypeEnum getActionType();
	String getUniqueTransactionIdentifier();
	String getSubmitterIdentifier();
	String getEntityResponsibleForReporting();
	BigDecimal getNumberRecords();
	String getTechnicalRecordId();
	String getRemarks();
	PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

	/*********************** Build Methods  ***********************/
	HKMAValuationReport build();
	
	HKMAValuationReport.HKMAValuationReportBuilder toBuilder();
	
	static HKMAValuationReport.HKMAValuationReportBuilder builder() {
		return new HKMAValuationReport.HKMAValuationReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends HKMAValuationReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends HKMAValuationReport> getType() {
		return HKMAValuationReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, getNumberRecords(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("remarks"), String.class, getRemarks(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface HKMAValuationReportBuilder extends HKMAValuationReport, RosettaModelObjectBuilder {
		HKMAValuationReport.HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		HKMAValuationReport.HKMAValuationReportBuilder setCounterparty1(String counterparty1);
		HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2(String counterparty2);
		HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2Name(String counterparty2Name);
		HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean counterparty2IdentifierTypeIndicator);
		HKMAValuationReport.HKMAValuationReportBuilder setValuationAmount(BigDecimal valuationAmount);
		HKMAValuationReport.HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		HKMAValuationReport.HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		HKMAValuationReport.HKMAValuationReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		HKMAValuationReport.HKMAValuationReportBuilder setDelta(BigDecimal delta);
		HKMAValuationReport.HKMAValuationReportBuilder setActionType(ActionTypeEnum actionType);
		HKMAValuationReport.HKMAValuationReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		HKMAValuationReport.HKMAValuationReportBuilder setSubmitterIdentifier(String submitterIdentifier);
		HKMAValuationReport.HKMAValuationReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		HKMAValuationReport.HKMAValuationReportBuilder setNumberRecords(BigDecimal numberRecords);
		HKMAValuationReport.HKMAValuationReportBuilder setTechnicalRecordId(String technicalRecordId);
		HKMAValuationReport.HKMAValuationReportBuilder setRemarks(String remarks);
		HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum counterparty2IdentifierFormat);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, getNumberRecords(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("remarks"), String.class, getRemarks(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, getCounterparty2IdentifierFormat(), this);
		}
		

		HKMAValuationReport.HKMAValuationReportBuilder prune();
	}

	/*********************** Immutable Implementation of HKMAValuationReport  ***********************/
	class HKMAValuationReportImpl implements HKMAValuationReport {
		private final ZonedDateTime reportingTimestamp;
		private final String counterparty1;
		private final String counterparty2;
		private final String counterparty2Name;
		private final Boolean counterparty2IdentifierTypeIndicator;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ZonedDateTime valuationTimestamp;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final ActionTypeEnum actionType;
		private final String uniqueTransactionIdentifier;
		private final String submitterIdentifier;
		private final String entityResponsibleForReporting;
		private final BigDecimal numberRecords;
		private final String technicalRecordId;
		private final String remarks;
		private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		
		protected HKMAValuationReportImpl(HKMAValuationReport.HKMAValuationReportBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2Name = builder.getCounterparty2Name();
			this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.actionType = builder.getActionType();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.numberRecords = builder.getNumberRecords();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.remarks = builder.getRemarks();
			this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public ActionTypeEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public BigDecimal getNumberRecords() {
			return numberRecords;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public String getRemarks() {
			return remarks;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		public HKMAValuationReport build() {
			return this;
		}
		
		@Override
		public HKMAValuationReport.HKMAValuationReportBuilder toBuilder() {
			HKMAValuationReport.HKMAValuationReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(HKMAValuationReport.HKMAValuationReportBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
			ofNullable(getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getNumberRecords()).ifPresent(builder::setNumberRecords);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getRemarks()).ifPresent(builder::setRemarks);
			ofNullable(getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(numberRecords, _that.getNumberRecords())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(remarks, _that.getRemarks())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (numberRecords != null ? numberRecords.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (remarks != null ? remarks.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAValuationReport {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"actionType=" + this.actionType + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"numberRecords=" + this.numberRecords + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"remarks=" + this.remarks + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat +
			'}';
		}
	}

	/*********************** Builder Implementation of HKMAValuationReport  ***********************/
	class HKMAValuationReportBuilderImpl implements HKMAValuationReport.HKMAValuationReportBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String counterparty1;
		protected String counterparty2;
		protected String counterparty2Name;
		protected Boolean counterparty2IdentifierTypeIndicator;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ZonedDateTime valuationTimestamp;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected ActionTypeEnum actionType;
		protected String uniqueTransactionIdentifier;
		protected String submitterIdentifier;
		protected String entityResponsibleForReporting;
		protected BigDecimal numberRecords;
		protected String technicalRecordId;
		protected String remarks;
		protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public ActionTypeEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public BigDecimal getNumberRecords() {
			return numberRecords;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public String getRemarks() {
			return remarks;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
			return counterparty2IdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public HKMAValuationReport.HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public HKMAValuationReport.HKMAValuationReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierTypeIndicator")
		@RuneAttribute("counterparty2IdentifierTypeIndicator")
		public HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
			this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public HKMAValuationReport.HKMAValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public HKMAValuationReport.HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public HKMAValuationReport.HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public HKMAValuationReport.HKMAValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public HKMAValuationReport.HKMAValuationReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public HKMAValuationReport.HKMAValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public HKMAValuationReport.HKMAValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("submitterIdentifier")
		@RuneAttribute("submitterIdentifier")
		public HKMAValuationReport.HKMAValuationReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public HKMAValuationReport.HKMAValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("numberRecords")
		@RuneAttribute("numberRecords")
		public HKMAValuationReport.HKMAValuationReportBuilder setNumberRecords(BigDecimal _numberRecords) {
			this.numberRecords = _numberRecords == null ? null : _numberRecords;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public HKMAValuationReport.HKMAValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("remarks")
		@RuneAttribute("remarks")
		public HKMAValuationReport.HKMAValuationReportBuilder setRemarks(String _remarks) {
			this.remarks = _remarks == null ? null : _remarks;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierFormat")
		@RuneAttribute("counterparty2IdentifierFormat")
		public HKMAValuationReport.HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
			this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
			return this;
		}
		
		@Override
		public HKMAValuationReport build() {
			return new HKMAValuationReport.HKMAValuationReportImpl(this);
		}
		
		@Override
		public HKMAValuationReport.HKMAValuationReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAValuationReport.HKMAValuationReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2Name()!=null) return true;
			if (getCounterparty2IdentifierTypeIndicator()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getActionType()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getNumberRecords()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getRemarks()!=null) return true;
			if (getCounterparty2IdentifierFormat()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAValuationReport.HKMAValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			HKMAValuationReport.HKMAValuationReportBuilder o = (HKMAValuationReport.HKMAValuationReportBuilder) other;
			
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2Name(), o.getCounterparty2Name(), this::setCounterparty2Name);
			merger.mergeBasic(getCounterparty2IdentifierTypeIndicator(), o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getNumberRecords(), o.getNumberRecords(), this::setNumberRecords);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getRemarks(), o.getRemarks(), this::setRemarks);
			merger.mergeBasic(getCounterparty2IdentifierFormat(), o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(numberRecords, _that.getNumberRecords())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(remarks, _that.getRemarks())) return false;
			if (!Objects.equals(counterparty2IdentifierFormat, _that.getCounterparty2IdentifierFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (numberRecords != null ? numberRecords.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (remarks != null ? remarks.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierFormat != null ? counterparty2IdentifierFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAValuationReportBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"actionType=" + this.actionType + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"numberRecords=" + this.numberRecords + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"remarks=" + this.remarks + ", " +
				"counterparty2IdentifierFormat=" + this.counterparty2IdentifierFormat +
			'}';
		}
	}
}
