package drr.regulation.jfsa.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class CollateralReportTypeFormatValidator implements Validator<CollateralReport> {

	private List<ComparisonResult> getComparisonResults(CollateralReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("uti", o.getUti(), 0, of(52), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkNumber("initialMarginPostedByTheReportingCounterpartyPreHaircut", o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginPostedByTheReportingCounterpartyPostHaircut", o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByReportingCounterpartyPreHaircut", o.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByReportingCounterpartyPostHaircut", o.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkString("variationMarginCollateralPortfolioCode", o.getVariationMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkNumber("variationMarginPostedByTheReportingCounterpartyPreHaircut", o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingCounterpartyPostHaircut", o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterpartyPreHaircut", o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterpartyPostHaircut", o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralPostedByTheReportingCounterparty", o.getExcessCollateralPostedByTheReportingCounterparty(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralCollectedByTheReportingCounterparty", o.getExcessCollateralCollectedByTheReportingCounterparty(), of(25), of(5), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CollateralReport", ValidationType.TYPE_FORMAT, "CollateralReport", path, "", res.getError());
				}
				return success("CollateralReport", ValidationType.TYPE_FORMAT, "CollateralReport", path, "");
			})
			.collect(toList());
	}

}
