package drr.regulation.jfsa.rewrite.margin.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CollateralReportValidator implements Validator<CollateralReport> {

	private List<ComparisonResult> getComparisonResults(CollateralReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("uti", (String) o.getUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralisationCategory", (CollateralisationType3Code__1) o.getCollateralisationCategory() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyofInitialMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByReportingCounterpartyPreHaircut", (BigDecimal) o.getInitialMarginCollectedByReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByReportingCounterpartyPostHaircut", (BigDecimal) o.getInitialMarginCollectedByReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyofInitialMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("excessCollateralPostedByTheReportingCounterparty", (BigDecimal) o.getExcessCollateralPostedByTheReportingCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfTheExcessCollateralPosted", (String) o.getCurrencyOfTheExcessCollateralPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("excessCollateralCollectedByTheReportingCounterparty", (BigDecimal) o.getExcessCollateralCollectedByTheReportingCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfTheExcessCollateralCollected", (String) o.getCurrencyOfTheExcessCollateralCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (MarginActionEnum) o.getActionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CollateralReport", ValidationType.CARDINALITY, "CollateralReport", path, "", res.getError());
				}
				return success("CollateralReport", ValidationType.CARDINALITY, "CollateralReport", path, "");
			})
			.collect(toList());
	}

}
