package drr.regulation.jfsa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilder;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilderImpl;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable.JFSANonReportableBuilder;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport.JFSATransactionReportBuilder;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport.JFSATransactionReportBuilderImpl;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport.JFSATransactionReportImpl;
import drr.regulation.jfsa.rewrite.trade.meta.JFSATransactionReportMeta;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="JFSATransactionReport", builder=JFSATransactionReport.JFSATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="JFSATransactionReport", model="drr", builder=JFSATransactionReport.JFSATransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface JFSATransactionReport extends CommonTransactionReport {

	JFSATransactionReportMeta metaData = new JFSATransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getEntityResponsibleForReporting();
	String getNewSDRIdentifier();
	String getOriginalSwapSDRIdentifier();
	ZonedDateTime getConfirmationTimestamp();
	ClearingAccountOriginEnum getClearingAccountOrigin();
	String getOriginalSwapUTI();
	String getOriginalSwapUTIProprietary();
	ZonedDateTime getClearingReceiptTimestamp();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	ZonedDateTime getValuationTimestamp();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	IndexEnum getUnderlyingIndexIndicator();
	String getReferenceEntity();
	Boolean getIsCrypto();
	Integer getVersion();
	BigDecimal getDelta();
	String getCustomBasketCode();
	JFSANonReportable getNonReportable();

	/*********************** Build Methods  ***********************/
	JFSATransactionReport build();
	
	JFSATransactionReport.JFSATransactionReportBuilder toBuilder();
	
	static JFSATransactionReport.JFSATransactionReportBuilder builder() {
		return new JFSATransactionReport.JFSATransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends JFSATransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends JFSATransactionReport> getType() {
		return JFSATransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
		processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, getOriginalSwapUTIProprietary(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("underlyingIndexIndicator"), IndexEnum.class, getUnderlyingIndexIndicator(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface JFSATransactionReportBuilder extends JFSATransactionReport, CommonTransactionReport.CommonTransactionReportBuilder {
		JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable();
		@Override
		JFSANonReportable.JFSANonReportableBuilder getNonReportable();
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPrice(PriceFormat price);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setLeg1(Leg leg1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setLeg2(Leg leg2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setSeries(Integer series);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		JFSATransactionReport.JFSATransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		JFSATransactionReport.JFSATransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		JFSATransactionReport.JFSATransactionReportBuilder setNewSDRIdentifier(String newSDRIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String originalSwapSDRIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum clearingAccountOrigin);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTI(String originalSwapUTI);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String originalSwapUTIProprietary);
		JFSATransactionReport.JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		JFSATransactionReport.JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIndexIndicator(IndexEnum underlyingIndexIndicator);
		JFSATransactionReport.JFSATransactionReportBuilder setReferenceEntity(String referenceEntity);
		JFSATransactionReport.JFSATransactionReportBuilder setIsCrypto(Boolean isCrypto);
		JFSATransactionReport.JFSATransactionReportBuilder setVersion(Integer version);
		JFSATransactionReport.JFSATransactionReportBuilder setDelta(BigDecimal delta);
		JFSATransactionReport.JFSATransactionReportBuilder setCustomBasketCode(String customBasketCode);
		JFSATransactionReport.JFSATransactionReportBuilder setNonReportable(JFSANonReportable nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
			processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, getOriginalSwapUTIProprietary(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("underlyingIndexIndicator"), IndexEnum.class, getUnderlyingIndexIndicator(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.JFSANonReportableBuilder.class, getNonReportable());
		}
		

		JFSATransactionReport.JFSATransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of JFSATransactionReport  ***********************/
	class JFSATransactionReportImpl extends CommonTransactionReport.CommonTransactionReportImpl implements JFSATransactionReport {
		private final String entityResponsibleForReporting;
		private final String newSDRIdentifier;
		private final String originalSwapSDRIdentifier;
		private final ZonedDateTime confirmationTimestamp;
		private final ClearingAccountOriginEnum clearingAccountOrigin;
		private final String originalSwapUTI;
		private final String originalSwapUTIProprietary;
		private final ZonedDateTime clearingReceiptTimestamp;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final ZonedDateTime valuationTimestamp;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final IndexEnum underlyingIndexIndicator;
		private final String referenceEntity;
		private final Boolean isCrypto;
		private final Integer version;
		private final BigDecimal delta;
		private final String customBasketCode;
		private final JFSANonReportable nonReportable;
		
		protected JFSATransactionReportImpl(JFSATransactionReport.JFSATransactionReportBuilder builder) {
			super(builder);
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.newSDRIdentifier = builder.getNewSDRIdentifier();
			this.originalSwapSDRIdentifier = builder.getOriginalSwapSDRIdentifier();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.clearingAccountOrigin = builder.getClearingAccountOrigin();
			this.originalSwapUTI = builder.getOriginalSwapUTI();
			this.originalSwapUTIProprietary = builder.getOriginalSwapUTIProprietary();
			this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.underlyingIndexIndicator = builder.getUnderlyingIndexIndicator();
			this.referenceEntity = builder.getReferenceEntity();
			this.isCrypto = builder.getIsCrypto();
			this.version = builder.getVersion();
			this.delta = builder.getDelta();
			this.customBasketCode = builder.getCustomBasketCode();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		public String getOriginalSwapUTIProprietary() {
			return originalSwapUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public IndexEnum getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public JFSANonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public JFSATransactionReport build() {
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder toBuilder() {
			JFSATransactionReport.JFSATransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(JFSATransactionReport.JFSATransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
			ofNullable(getOriginalSwapSDRIdentifier()).ifPresent(builder::setOriginalSwapSDRIdentifier);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
			ofNullable(getOriginalSwapUTI()).ifPresent(builder::setOriginalSwapUTI);
			ofNullable(getOriginalSwapUTIProprietary()).ifPresent(builder::setOriginalSwapUTIProprietary);
			ofNullable(getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getUnderlyingIndexIndicator()).ifPresent(builder::setUnderlyingIndexIndicator);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getIsCrypto()).ifPresent(builder::setIsCrypto);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			JFSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTIProprietary != null ? originalSwapUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSATransactionReport {" +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"version=" + this.version + ", " +
				"delta=" + this.delta + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"nonReportable=" + this.nonReportable +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of JFSATransactionReport  ***********************/
	class JFSATransactionReportBuilderImpl extends CommonTransactionReport.CommonTransactionReportBuilderImpl implements JFSATransactionReport.JFSATransactionReportBuilder {
	
		protected String entityResponsibleForReporting;
		protected String newSDRIdentifier;
		protected String originalSwapSDRIdentifier;
		protected ZonedDateTime confirmationTimestamp;
		protected ClearingAccountOriginEnum clearingAccountOrigin;
		protected String originalSwapUTI;
		protected String originalSwapUTIProprietary;
		protected ZonedDateTime clearingReceiptTimestamp;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected ZonedDateTime valuationTimestamp;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected IndexEnum underlyingIndexIndicator;
		protected String referenceEntity;
		protected Boolean isCrypto;
		protected Integer version;
		protected BigDecimal delta;
		protected String customBasketCode;
		protected JFSANonReportable.JFSANonReportableBuilder nonReportable;
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		public String getOriginalSwapUTIProprietary() {
			return originalSwapUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public IndexEnum getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public JFSANonReportable.JFSANonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable() {
			JFSANonReportable.JFSANonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = JFSANonReportable.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public JFSATransactionReport.JFSATransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public JFSATransactionReport.JFSATransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public JFSATransactionReport.JFSATransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public JFSATransactionReport.JFSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public JFSATransactionReport.JFSATransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public JFSATransactionReport.JFSATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public JFSATransactionReport.JFSATransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public JFSATransactionReport.JFSATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public JFSATransactionReport.JFSATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public JFSATransactionReport.JFSATransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public JFSATransactionReport.JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public JFSATransactionReport.JFSATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public JFSATransactionReport.JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public JFSATransactionReport.JFSATransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public JFSATransactionReport.JFSATransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public JFSATransactionReport.JFSATransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public JFSATransactionReport.JFSATransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public JFSATransactionReport.JFSATransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public JFSATransactionReport.JFSATransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public JFSATransactionReport.JFSATransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public JFSATransactionReport.JFSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public JFSATransactionReport.JFSATransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public JFSATransactionReport.JFSATransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public JFSATransactionReport.JFSATransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public JFSATransactionReport.JFSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public JFSATransactionReport.JFSATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public JFSATransactionReport.JFSATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public JFSATransactionReport.JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public JFSATransactionReport.JFSATransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public JFSATransactionReport.JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public JFSATransactionReport.JFSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public JFSATransactionReport.JFSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public JFSATransactionReport.JFSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public JFSATransactionReport.JFSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public JFSATransactionReport.JFSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public JFSATransactionReport.JFSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public JFSATransactionReport.JFSATransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public JFSATransactionReport.JFSATransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public JFSATransactionReport.JFSATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public JFSATransactionReport.JFSATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public JFSATransactionReport.JFSATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
			this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
			this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String _originalSwapUTIProprietary) {
			this.originalSwapUTIProprietary = _originalSwapUTIProprietary == null ? null : _originalSwapUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public JFSATransactionReport.JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public JFSATransactionReport.JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIndexIndicator(IndexEnum _underlyingIndexIndicator) {
			this.underlyingIndexIndicator = _underlyingIndexIndicator == null ? null : _underlyingIndexIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public JFSATransactionReport.JFSATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public JFSATransactionReport.JFSATransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public JFSATransactionReport.JFSATransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public JFSATransactionReport.JFSATransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public JFSATransactionReport.JFSATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public JFSATransactionReport.JFSATransactionReportBuilder setNonReportable(JFSANonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public JFSATransactionReport build() {
			return new JFSATransactionReport.JFSATransactionReportImpl(this);
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder prune() {
			super.prune();
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getNewSDRIdentifier()!=null) return true;
			if (getOriginalSwapSDRIdentifier()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getClearingAccountOrigin()!=null) return true;
			if (getOriginalSwapUTI()!=null) return true;
			if (getOriginalSwapUTIProprietary()!=null) return true;
			if (getClearingReceiptTimestamp()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getUnderlyingIndexIndicator()!=null) return true;
			if (getReferenceEntity()!=null) return true;
			if (getIsCrypto()!=null) return true;
			if (getVersion()!=null) return true;
			if (getDelta()!=null) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			JFSATransactionReport.JFSATransactionReportBuilder o = (JFSATransactionReport.JFSATransactionReportBuilder) other;
			
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getNewSDRIdentifier(), o.getNewSDRIdentifier(), this::setNewSDRIdentifier);
			merger.mergeBasic(getOriginalSwapSDRIdentifier(), o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getClearingAccountOrigin(), o.getClearingAccountOrigin(), this::setClearingAccountOrigin);
			merger.mergeBasic(getOriginalSwapUTI(), o.getOriginalSwapUTI(), this::setOriginalSwapUTI);
			merger.mergeBasic(getOriginalSwapUTIProprietary(), o.getOriginalSwapUTIProprietary(), this::setOriginalSwapUTIProprietary);
			merger.mergeBasic(getClearingReceiptTimestamp(), o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getUnderlyingIndexIndicator(), o.getUnderlyingIndexIndicator(), this::setUnderlyingIndexIndicator);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getIsCrypto(), o.getIsCrypto(), this::setIsCrypto);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			JFSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTIProprietary != null ? originalSwapUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSATransactionReportBuilder {" +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"version=" + this.version + ", " +
				"delta=" + this.delta + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"nonReportable=" + this.nonReportable +
			'}' + " " + super.toString();
		}
	}
}
