package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.IndexEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0111_01")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0111_01.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0111_01 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0111_01";
	String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and assetClass = CommonAssetClass -> INTR then (if underlying -> underlyingIdentificationType = \"I\" then underlying -> underlyingIdentification exists else if underlying -> underlyingIdentificationType = \"X\" and underlyingIndexIndicator is absent and nameOfTheUnderlyingIndex is absent then underlying -> underlyingIdentification exists)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0111_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<ActionTypeEnum>of(MapperS.of(ActionTypeEnum.NEWT), MapperS.of(ActionTypeEnum.MODI), MapperS.of(ActionTypeEnum.CORR), MapperS.of(ActionTypeEnum.REVI)), MapperS.of(jFSATransactionReport).<ActionTypeEnum>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(jFSATransactionReport).<CommonAssetClass>map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.INTR), CardinalityOperator.All)).getOrDefault(false)) {
					if (areEqual(MapperS.of(jFSATransactionReport).<UnderlyingIdentifier>map("getUnderlying", _jFSATransactionReport -> _jFSATransactionReport.getUnderlying()).<String>map("getUnderlyingIdentificationType", underlyingIdentifier -> underlyingIdentifier.getUnderlyingIdentificationType()), MapperS.of("I"), CardinalityOperator.All).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<UnderlyingIdentifier>map("getUnderlying", _jFSATransactionReport -> _jFSATransactionReport.getUnderlying()).<String>map("getUnderlyingIdentification", underlyingIdentifier -> underlyingIdentifier.getUnderlyingIdentification()));
					}
					if (areEqual(MapperS.of(jFSATransactionReport).<UnderlyingIdentifier>map("getUnderlying", _jFSATransactionReport -> _jFSATransactionReport.getUnderlying()).<String>map("getUnderlyingIdentificationType", underlyingIdentifier -> underlyingIdentifier.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).and(notExists(MapperS.of(jFSATransactionReport).<IndexEnum>map("getUnderlyingIndexIndicator", _jFSATransactionReport -> _jFSATransactionReport.getUnderlyingIndexIndicator()))).and(notExists(MapperS.of(jFSATransactionReport).<String>map("getNameOfTheUnderlyingIndex", _jFSATransactionReport -> _jFSATransactionReport.getNameOfTheUnderlyingIndex()))).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<UnderlyingIdentifier>map("getUnderlying", _jFSATransactionReport -> _jFSATransactionReport.getUnderlying()).<String>map("getUnderlyingIdentification", underlyingIdentifier -> underlyingIdentifier.getUnderlyingIdentification()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0111_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
