package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.reports.SpreadLeg1NotationEnumRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadNotationOfLeg1Rule.SpreadNotationOfLeg1RuleDefault.class)
public abstract class SpreadNotationOfLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected SpreadLeg1NotationEnumRule spreadLeg1NotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadNotationOfLeg1RuleDefault extends SpreadNotationOfLeg1Rule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(spreadLeg1NotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(PriceNotationEnum.DECIMAL);
					}
					return MapperS.of(spreadLeg1NotationEnumRule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
