package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.reports.StrikePriceNotationEnumRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(StrikePriceNotationRule.StrikePriceNotationRuleDefault.class)
public abstract class StrikePriceNotationRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceNotationRuleDefault extends StrikePriceNotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(strikePriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).or(areEqual(MapperS.of(strikePriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(isVarianceSwap.evaluate(productForEvent.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isVolatilitySwap.evaluate(productForEvent.evaluate(item.get()))))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(productForEvent.evaluate(item.get()))))))).getOrDefault(false)) {
						return MapperS.of(PriceNotationEnum.DECIMAL);
					}
					return MapperS.of(strikePriceNotationEnumRule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
