package drr.regulation.techsprint.g20.mas;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport.MASSFATransactionReportBuilder;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport.MASSFATransactionReportBuilderImpl;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport.MASSFATransactionReportImpl;
import drr.regulation.techsprint.g20.mas.meta.MASSFATransactionReportMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 0.0.0
 */
@RosettaDataType(value="MASSFATransactionReport", builder=MASSFATransactionReport.MASSFATransactionReportBuilderImpl.class, version="0.0.0")
@RuneDataType(value="MASSFATransactionReport", model="drr", builder=MASSFATransactionReport.MASSFATransactionReportBuilderImpl.class, version="0.0.0")
public interface MASSFATransactionReport extends RosettaModelObject {

	MASSFATransactionReportMeta metaData = new MASSFATransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUniqueTransactionIdentifier();
	String getUniqueProductIdentifier();
	String getPriorUniqueTransactionIdentifier();
	String getCounterparty1();
	String getCounterparty2();
	String getReportingEntity();
	String getCleared();
	String getClearedEntity();
	Date getEffectiveDate();
	Date getTerminationDate();
	ZonedDateTime getReportingTimestamp();
	String getOptionType();
	String getOptionExpirationDate();
	String getOptionPremium();
	BigDecimal getInterestRateNotionalAmountLeg1();
	String getInterestRateNotionalCurrencyLeg1();
	BigDecimal getInterestRateNotionalAmountLeg2();
	String getInterestRateNotionalCurrencyLeg2();
	String getInterestRatePayerLeg1();
	String getInterestRatePayerLeg2();
	BigDecimal getInterestRateRateLeg1();
	BigDecimal getInterestRateRateLeg2();
	PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg1();
	Integer getInterestRatePaymentFrequencyMultiplierLeg1();
	PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg2();
	Integer getInterestRatePaymentFrequencyMultiplierLeg2();
	DayCountFractionEnum getInterestRateDayCountLeg1();
	DayCountFractionEnum getInterestRateDayCountLeg2();
	PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg1();
	Integer getInterestRateResetFrequencyMultiplierLeg1();
	PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg2();
	Integer getInterestRateResetFrequencyMultiplierLeg2();
	BigDecimal getInterestRatePrice();
	String getFXCurrency1();
	String getFXCurrency2();
	BigDecimal getFXExchangeRate();

	/*********************** Build Methods  ***********************/
	MASSFATransactionReport build();
	
	MASSFATransactionReport.MASSFATransactionReportBuilder toBuilder();
	
	static MASSFATransactionReport.MASSFATransactionReportBuilder builder() {
		return new MASSFATransactionReport.MASSFATransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends MASSFATransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends MASSFATransactionReport> getType() {
		return MASSFATransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("priorUniqueTransactionIdentifier"), String.class, getPriorUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("clearedEntity"), String.class, getClearedEntity(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("terminationDate"), Date.class, getTerminationDate(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionExpirationDate"), String.class, getOptionExpirationDate(), this);
		processor.processBasic(path.newSubPath("optionPremium"), String.class, getOptionPremium(), this);
		processor.processBasic(path.newSubPath("interestRateNotionalAmountLeg1"), BigDecimal.class, getInterestRateNotionalAmountLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateNotionalCurrencyLeg1"), String.class, getInterestRateNotionalCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateNotionalAmountLeg2"), BigDecimal.class, getInterestRateNotionalAmountLeg2(), this);
		processor.processBasic(path.newSubPath("interestRateNotionalCurrencyLeg2"), String.class, getInterestRateNotionalCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("interestRatePayerLeg1"), String.class, getInterestRatePayerLeg1(), this);
		processor.processBasic(path.newSubPath("interestRatePayerLeg2"), String.class, getInterestRatePayerLeg2(), this);
		processor.processBasic(path.newSubPath("interestRateRateLeg1"), BigDecimal.class, getInterestRateRateLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateRateLeg2"), BigDecimal.class, getInterestRateRateLeg2(), this);
		processor.processBasic(path.newSubPath("interestRatePaymentFrequencyPeriodLeg1"), PeriodExtendedEnum.class, getInterestRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("interestRatePaymentFrequencyMultiplierLeg1"), Integer.class, getInterestRatePaymentFrequencyMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("interestRatePaymentFrequencyPeriodLeg2"), PeriodExtendedEnum.class, getInterestRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("interestRatePaymentFrequencyMultiplierLeg2"), Integer.class, getInterestRatePaymentFrequencyMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("interestRateDayCountLeg1"), DayCountFractionEnum.class, getInterestRateDayCountLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateDayCountLeg2"), DayCountFractionEnum.class, getInterestRateDayCountLeg2(), this);
		processor.processBasic(path.newSubPath("interestRateResetFrequencyPeriodLeg1"), PeriodExtendedEnum.class, getInterestRateResetFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateResetFrequencyMultiplierLeg1"), Integer.class, getInterestRateResetFrequencyMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("interestRateResetFrequencyPeriodLeg2"), PeriodExtendedEnum.class, getInterestRateResetFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("interestRateResetFrequencyMultiplierLeg2"), Integer.class, getInterestRateResetFrequencyMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("interestRatePrice"), BigDecimal.class, getInterestRatePrice(), this);
		processor.processBasic(path.newSubPath("fXCurrency1"), String.class, getFXCurrency1(), this);
		processor.processBasic(path.newSubPath("fXCurrency2"), String.class, getFXCurrency2(), this);
		processor.processBasic(path.newSubPath("fXExchangeRate"), BigDecimal.class, getFXExchangeRate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface MASSFATransactionReportBuilder extends MASSFATransactionReport, RosettaModelObjectBuilder {
		MASSFATransactionReport.MASSFATransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		MASSFATransactionReport.MASSFATransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		MASSFATransactionReport.MASSFATransactionReportBuilder setPriorUniqueTransactionIdentifier(String priorUniqueTransactionIdentifier);
		MASSFATransactionReport.MASSFATransactionReportBuilder setCounterparty1(String counterparty1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setCounterparty2(String counterparty2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setReportingEntity(String reportingEntity);
		MASSFATransactionReport.MASSFATransactionReportBuilder setCleared(String cleared);
		MASSFATransactionReport.MASSFATransactionReportBuilder setClearedEntity(String clearedEntity);
		MASSFATransactionReport.MASSFATransactionReportBuilder setEffectiveDate(Date effectiveDate);
		MASSFATransactionReport.MASSFATransactionReportBuilder setTerminationDate(Date terminationDate);
		MASSFATransactionReport.MASSFATransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		MASSFATransactionReport.MASSFATransactionReportBuilder setOptionType(String optionType);
		MASSFATransactionReport.MASSFATransactionReportBuilder setOptionExpirationDate(String optionExpirationDate);
		MASSFATransactionReport.MASSFATransactionReportBuilder setOptionPremium(String optionPremium);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalAmountLeg1(BigDecimal interestRateNotionalAmountLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalCurrencyLeg1(String interestRateNotionalCurrencyLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalAmountLeg2(BigDecimal interestRateNotionalAmountLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalCurrencyLeg2(String interestRateNotionalCurrencyLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePayerLeg1(String interestRatePayerLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePayerLeg2(String interestRatePayerLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateRateLeg1(BigDecimal interestRateRateLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateRateLeg2(BigDecimal interestRateRateLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyPeriodLeg1(PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyMultiplierLeg1(Integer interestRatePaymentFrequencyMultiplierLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyPeriodLeg2(PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyMultiplierLeg2(Integer interestRatePaymentFrequencyMultiplierLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateDayCountLeg1(DayCountFractionEnum interestRateDayCountLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateDayCountLeg2(DayCountFractionEnum interestRateDayCountLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyPeriodLeg1(PeriodExtendedEnum interestRateResetFrequencyPeriodLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyMultiplierLeg1(Integer interestRateResetFrequencyMultiplierLeg1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyPeriodLeg2(PeriodExtendedEnum interestRateResetFrequencyPeriodLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyMultiplierLeg2(Integer interestRateResetFrequencyMultiplierLeg2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePrice(BigDecimal interestRatePrice);
		MASSFATransactionReport.MASSFATransactionReportBuilder setFXCurrency1(String fXCurrency1);
		MASSFATransactionReport.MASSFATransactionReportBuilder setFXCurrency2(String fXCurrency2);
		MASSFATransactionReport.MASSFATransactionReportBuilder setFXExchangeRate(BigDecimal fXExchangeRate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("priorUniqueTransactionIdentifier"), String.class, getPriorUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("clearedEntity"), String.class, getClearedEntity(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("terminationDate"), Date.class, getTerminationDate(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionExpirationDate"), String.class, getOptionExpirationDate(), this);
			processor.processBasic(path.newSubPath("optionPremium"), String.class, getOptionPremium(), this);
			processor.processBasic(path.newSubPath("interestRateNotionalAmountLeg1"), BigDecimal.class, getInterestRateNotionalAmountLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateNotionalCurrencyLeg1"), String.class, getInterestRateNotionalCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateNotionalAmountLeg2"), BigDecimal.class, getInterestRateNotionalAmountLeg2(), this);
			processor.processBasic(path.newSubPath("interestRateNotionalCurrencyLeg2"), String.class, getInterestRateNotionalCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("interestRatePayerLeg1"), String.class, getInterestRatePayerLeg1(), this);
			processor.processBasic(path.newSubPath("interestRatePayerLeg2"), String.class, getInterestRatePayerLeg2(), this);
			processor.processBasic(path.newSubPath("interestRateRateLeg1"), BigDecimal.class, getInterestRateRateLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateRateLeg2"), BigDecimal.class, getInterestRateRateLeg2(), this);
			processor.processBasic(path.newSubPath("interestRatePaymentFrequencyPeriodLeg1"), PeriodExtendedEnum.class, getInterestRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("interestRatePaymentFrequencyMultiplierLeg1"), Integer.class, getInterestRatePaymentFrequencyMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("interestRatePaymentFrequencyPeriodLeg2"), PeriodExtendedEnum.class, getInterestRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("interestRatePaymentFrequencyMultiplierLeg2"), Integer.class, getInterestRatePaymentFrequencyMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("interestRateDayCountLeg1"), DayCountFractionEnum.class, getInterestRateDayCountLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateDayCountLeg2"), DayCountFractionEnum.class, getInterestRateDayCountLeg2(), this);
			processor.processBasic(path.newSubPath("interestRateResetFrequencyPeriodLeg1"), PeriodExtendedEnum.class, getInterestRateResetFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateResetFrequencyMultiplierLeg1"), Integer.class, getInterestRateResetFrequencyMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("interestRateResetFrequencyPeriodLeg2"), PeriodExtendedEnum.class, getInterestRateResetFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("interestRateResetFrequencyMultiplierLeg2"), Integer.class, getInterestRateResetFrequencyMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("interestRatePrice"), BigDecimal.class, getInterestRatePrice(), this);
			processor.processBasic(path.newSubPath("fXCurrency1"), String.class, getFXCurrency1(), this);
			processor.processBasic(path.newSubPath("fXCurrency2"), String.class, getFXCurrency2(), this);
			processor.processBasic(path.newSubPath("fXExchangeRate"), BigDecimal.class, getFXExchangeRate(), this);
		}
		

		MASSFATransactionReport.MASSFATransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of MASSFATransactionReport  ***********************/
	class MASSFATransactionReportImpl implements MASSFATransactionReport {
		private final String uniqueTransactionIdentifier;
		private final String uniqueProductIdentifier;
		private final String priorUniqueTransactionIdentifier;
		private final String counterparty1;
		private final String counterparty2;
		private final String reportingEntity;
		private final String cleared;
		private final String clearedEntity;
		private final Date effectiveDate;
		private final Date terminationDate;
		private final ZonedDateTime reportingTimestamp;
		private final String optionType;
		private final String optionExpirationDate;
		private final String optionPremium;
		private final BigDecimal interestRateNotionalAmountLeg1;
		private final String interestRateNotionalCurrencyLeg1;
		private final BigDecimal interestRateNotionalAmountLeg2;
		private final String interestRateNotionalCurrencyLeg2;
		private final String interestRatePayerLeg1;
		private final String interestRatePayerLeg2;
		private final BigDecimal interestRateRateLeg1;
		private final BigDecimal interestRateRateLeg2;
		private final PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg1;
		private final Integer interestRatePaymentFrequencyMultiplierLeg1;
		private final PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg2;
		private final Integer interestRatePaymentFrequencyMultiplierLeg2;
		private final DayCountFractionEnum interestRateDayCountLeg1;
		private final DayCountFractionEnum interestRateDayCountLeg2;
		private final PeriodExtendedEnum interestRateResetFrequencyPeriodLeg1;
		private final Integer interestRateResetFrequencyMultiplierLeg1;
		private final PeriodExtendedEnum interestRateResetFrequencyPeriodLeg2;
		private final Integer interestRateResetFrequencyMultiplierLeg2;
		private final BigDecimal interestRatePrice;
		private final String fXCurrency1;
		private final String fXCurrency2;
		private final BigDecimal fXExchangeRate;
		
		protected MASSFATransactionReportImpl(MASSFATransactionReport.MASSFATransactionReportBuilder builder) {
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
			this.priorUniqueTransactionIdentifier = builder.getPriorUniqueTransactionIdentifier();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.reportingEntity = builder.getReportingEntity();
			this.cleared = builder.getCleared();
			this.clearedEntity = builder.getClearedEntity();
			this.effectiveDate = builder.getEffectiveDate();
			this.terminationDate = builder.getTerminationDate();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.optionType = builder.getOptionType();
			this.optionExpirationDate = builder.getOptionExpirationDate();
			this.optionPremium = builder.getOptionPremium();
			this.interestRateNotionalAmountLeg1 = builder.getInterestRateNotionalAmountLeg1();
			this.interestRateNotionalCurrencyLeg1 = builder.getInterestRateNotionalCurrencyLeg1();
			this.interestRateNotionalAmountLeg2 = builder.getInterestRateNotionalAmountLeg2();
			this.interestRateNotionalCurrencyLeg2 = builder.getInterestRateNotionalCurrencyLeg2();
			this.interestRatePayerLeg1 = builder.getInterestRatePayerLeg1();
			this.interestRatePayerLeg2 = builder.getInterestRatePayerLeg2();
			this.interestRateRateLeg1 = builder.getInterestRateRateLeg1();
			this.interestRateRateLeg2 = builder.getInterestRateRateLeg2();
			this.interestRatePaymentFrequencyPeriodLeg1 = builder.getInterestRatePaymentFrequencyPeriodLeg1();
			this.interestRatePaymentFrequencyMultiplierLeg1 = builder.getInterestRatePaymentFrequencyMultiplierLeg1();
			this.interestRatePaymentFrequencyPeriodLeg2 = builder.getInterestRatePaymentFrequencyPeriodLeg2();
			this.interestRatePaymentFrequencyMultiplierLeg2 = builder.getInterestRatePaymentFrequencyMultiplierLeg2();
			this.interestRateDayCountLeg1 = builder.getInterestRateDayCountLeg1();
			this.interestRateDayCountLeg2 = builder.getInterestRateDayCountLeg2();
			this.interestRateResetFrequencyPeriodLeg1 = builder.getInterestRateResetFrequencyPeriodLeg1();
			this.interestRateResetFrequencyMultiplierLeg1 = builder.getInterestRateResetFrequencyMultiplierLeg1();
			this.interestRateResetFrequencyPeriodLeg2 = builder.getInterestRateResetFrequencyPeriodLeg2();
			this.interestRateResetFrequencyMultiplierLeg2 = builder.getInterestRateResetFrequencyMultiplierLeg2();
			this.interestRatePrice = builder.getInterestRatePrice();
			this.fXCurrency1 = builder.getFXCurrency1();
			this.fXCurrency2 = builder.getFXCurrency2();
			this.fXExchangeRate = builder.getFXExchangeRate();
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("priorUniqueTransactionIdentifier")
		@RuneAttribute("priorUniqueTransactionIdentifier")
		public String getPriorUniqueTransactionIdentifier() {
			return priorUniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearedEntity")
		@RuneAttribute("clearedEntity")
		public String getClearedEntity() {
			return clearedEntity;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("terminationDate")
		@RuneAttribute("terminationDate")
		public Date getTerminationDate() {
			return terminationDate;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionExpirationDate")
		@RuneAttribute("optionExpirationDate")
		public String getOptionExpirationDate() {
			return optionExpirationDate;
		}
		
		@Override
		@RosettaAttribute("optionPremium")
		@RuneAttribute("optionPremium")
		public String getOptionPremium() {
			return optionPremium;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg1")
		@RuneAttribute("interestRateNotionalAmountLeg1")
		public BigDecimal getInterestRateNotionalAmountLeg1() {
			return interestRateNotionalAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg1")
		@RuneAttribute("interestRateNotionalCurrencyLeg1")
		public String getInterestRateNotionalCurrencyLeg1() {
			return interestRateNotionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg2")
		@RuneAttribute("interestRateNotionalAmountLeg2")
		public BigDecimal getInterestRateNotionalAmountLeg2() {
			return interestRateNotionalAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg2")
		@RuneAttribute("interestRateNotionalCurrencyLeg2")
		public String getInterestRateNotionalCurrencyLeg2() {
			return interestRateNotionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg1")
		@RuneAttribute("interestRatePayerLeg1")
		public String getInterestRatePayerLeg1() {
			return interestRatePayerLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg2")
		@RuneAttribute("interestRatePayerLeg2")
		public String getInterestRatePayerLeg2() {
			return interestRatePayerLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg1")
		@RuneAttribute("interestRateRateLeg1")
		public BigDecimal getInterestRateRateLeg1() {
			return interestRateRateLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg2")
		@RuneAttribute("interestRateRateLeg2")
		public BigDecimal getInterestRateRateLeg2() {
			return interestRateRateLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg1")
		public PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg1() {
			return interestRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		public Integer getInterestRatePaymentFrequencyMultiplierLeg1() {
			return interestRatePaymentFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg2")
		public PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg2() {
			return interestRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		public Integer getInterestRatePaymentFrequencyMultiplierLeg2() {
			return interestRatePaymentFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg1")
		@RuneAttribute("interestRateDayCountLeg1")
		public DayCountFractionEnum getInterestRateDayCountLeg1() {
			return interestRateDayCountLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg2")
		@RuneAttribute("interestRateDayCountLeg2")
		public DayCountFractionEnum getInterestRateDayCountLeg2() {
			return interestRateDayCountLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg1")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg1")
		public PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg1() {
			return interestRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg1")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg1")
		public Integer getInterestRateResetFrequencyMultiplierLeg1() {
			return interestRateResetFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg2")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg2")
		public PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg2() {
			return interestRateResetFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg2")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg2")
		public Integer getInterestRateResetFrequencyMultiplierLeg2() {
			return interestRateResetFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePrice")
		@RuneAttribute("interestRatePrice")
		public BigDecimal getInterestRatePrice() {
			return interestRatePrice;
		}
		
		@Override
		@RosettaAttribute("fXCurrency1")
		@RuneAttribute("fXCurrency1")
		public String getFXCurrency1() {
			return fXCurrency1;
		}
		
		@Override
		@RosettaAttribute("fXCurrency2")
		@RuneAttribute("fXCurrency2")
		public String getFXCurrency2() {
			return fXCurrency2;
		}
		
		@Override
		@RosettaAttribute("fXExchangeRate")
		@RuneAttribute("fXExchangeRate")
		public BigDecimal getFXExchangeRate() {
			return fXExchangeRate;
		}
		
		@Override
		public MASSFATransactionReport build() {
			return this;
		}
		
		@Override
		public MASSFATransactionReport.MASSFATransactionReportBuilder toBuilder() {
			MASSFATransactionReport.MASSFATransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(MASSFATransactionReport.MASSFATransactionReportBuilder builder) {
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
			ofNullable(getPriorUniqueTransactionIdentifier()).ifPresent(builder::setPriorUniqueTransactionIdentifier);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getReportingEntity()).ifPresent(builder::setReportingEntity);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getClearedEntity()).ifPresent(builder::setClearedEntity);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getTerminationDate()).ifPresent(builder::setTerminationDate);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getOptionExpirationDate()).ifPresent(builder::setOptionExpirationDate);
			ofNullable(getOptionPremium()).ifPresent(builder::setOptionPremium);
			ofNullable(getInterestRateNotionalAmountLeg1()).ifPresent(builder::setInterestRateNotionalAmountLeg1);
			ofNullable(getInterestRateNotionalCurrencyLeg1()).ifPresent(builder::setInterestRateNotionalCurrencyLeg1);
			ofNullable(getInterestRateNotionalAmountLeg2()).ifPresent(builder::setInterestRateNotionalAmountLeg2);
			ofNullable(getInterestRateNotionalCurrencyLeg2()).ifPresent(builder::setInterestRateNotionalCurrencyLeg2);
			ofNullable(getInterestRatePayerLeg1()).ifPresent(builder::setInterestRatePayerLeg1);
			ofNullable(getInterestRatePayerLeg2()).ifPresent(builder::setInterestRatePayerLeg2);
			ofNullable(getInterestRateRateLeg1()).ifPresent(builder::setInterestRateRateLeg1);
			ofNullable(getInterestRateRateLeg2()).ifPresent(builder::setInterestRateRateLeg2);
			ofNullable(getInterestRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setInterestRatePaymentFrequencyPeriodLeg1);
			ofNullable(getInterestRatePaymentFrequencyMultiplierLeg1()).ifPresent(builder::setInterestRatePaymentFrequencyMultiplierLeg1);
			ofNullable(getInterestRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setInterestRatePaymentFrequencyPeriodLeg2);
			ofNullable(getInterestRatePaymentFrequencyMultiplierLeg2()).ifPresent(builder::setInterestRatePaymentFrequencyMultiplierLeg2);
			ofNullable(getInterestRateDayCountLeg1()).ifPresent(builder::setInterestRateDayCountLeg1);
			ofNullable(getInterestRateDayCountLeg2()).ifPresent(builder::setInterestRateDayCountLeg2);
			ofNullable(getInterestRateResetFrequencyPeriodLeg1()).ifPresent(builder::setInterestRateResetFrequencyPeriodLeg1);
			ofNullable(getInterestRateResetFrequencyMultiplierLeg1()).ifPresent(builder::setInterestRateResetFrequencyMultiplierLeg1);
			ofNullable(getInterestRateResetFrequencyPeriodLeg2()).ifPresent(builder::setInterestRateResetFrequencyPeriodLeg2);
			ofNullable(getInterestRateResetFrequencyMultiplierLeg2()).ifPresent(builder::setInterestRateResetFrequencyMultiplierLeg2);
			ofNullable(getInterestRatePrice()).ifPresent(builder::setInterestRatePrice);
			ofNullable(getFXCurrency1()).ifPresent(builder::setFXCurrency1);
			ofNullable(getFXCurrency2()).ifPresent(builder::setFXCurrency2);
			ofNullable(getFXExchangeRate()).ifPresent(builder::setFXExchangeRate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASSFATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(priorUniqueTransactionIdentifier, _that.getPriorUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearedEntity, _that.getClearedEntity())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(terminationDate, _that.getTerminationDate())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionExpirationDate, _that.getOptionExpirationDate())) return false;
			if (!Objects.equals(optionPremium, _that.getOptionPremium())) return false;
			if (!Objects.equals(interestRateNotionalAmountLeg1, _that.getInterestRateNotionalAmountLeg1())) return false;
			if (!Objects.equals(interestRateNotionalCurrencyLeg1, _that.getInterestRateNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(interestRateNotionalAmountLeg2, _that.getInterestRateNotionalAmountLeg2())) return false;
			if (!Objects.equals(interestRateNotionalCurrencyLeg2, _that.getInterestRateNotionalCurrencyLeg2())) return false;
			if (!Objects.equals(interestRatePayerLeg1, _that.getInterestRatePayerLeg1())) return false;
			if (!Objects.equals(interestRatePayerLeg2, _that.getInterestRatePayerLeg2())) return false;
			if (!Objects.equals(interestRateRateLeg1, _that.getInterestRateRateLeg1())) return false;
			if (!Objects.equals(interestRateRateLeg2, _that.getInterestRateRateLeg2())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyPeriodLeg1, _that.getInterestRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyMultiplierLeg1, _that.getInterestRatePaymentFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyPeriodLeg2, _that.getInterestRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyMultiplierLeg2, _that.getInterestRatePaymentFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(interestRateDayCountLeg1, _that.getInterestRateDayCountLeg1())) return false;
			if (!Objects.equals(interestRateDayCountLeg2, _that.getInterestRateDayCountLeg2())) return false;
			if (!Objects.equals(interestRateResetFrequencyPeriodLeg1, _that.getInterestRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(interestRateResetFrequencyMultiplierLeg1, _that.getInterestRateResetFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(interestRateResetFrequencyPeriodLeg2, _that.getInterestRateResetFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(interestRateResetFrequencyMultiplierLeg2, _that.getInterestRateResetFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(interestRatePrice, _that.getInterestRatePrice())) return false;
			if (!Objects.equals(fXCurrency1, _that.getFXCurrency1())) return false;
			if (!Objects.equals(fXCurrency2, _that.getFXCurrency2())) return false;
			if (!Objects.equals(fXExchangeRate, _that.getFXExchangeRate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (priorUniqueTransactionIdentifier != null ? priorUniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearedEntity != null ? clearedEntity.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (terminationDate != null ? terminationDate.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionExpirationDate != null ? optionExpirationDate.hashCode() : 0);
			_result = 31 * _result + (optionPremium != null ? optionPremium.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalAmountLeg1 != null ? interestRateNotionalAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalCurrencyLeg1 != null ? interestRateNotionalCurrencyLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalAmountLeg2 != null ? interestRateNotionalAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalCurrencyLeg2 != null ? interestRateNotionalCurrencyLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePayerLeg1 != null ? interestRatePayerLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRatePayerLeg2 != null ? interestRatePayerLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateRateLeg1 != null ? interestRateRateLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateRateLeg2 != null ? interestRateRateLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyPeriodLeg1 != null ? interestRatePaymentFrequencyPeriodLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyMultiplierLeg1 != null ? interestRatePaymentFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyPeriodLeg2 != null ? interestRatePaymentFrequencyPeriodLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyMultiplierLeg2 != null ? interestRatePaymentFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateDayCountLeg1 != null ? interestRateDayCountLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateDayCountLeg2 != null ? interestRateDayCountLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyPeriodLeg1 != null ? interestRateResetFrequencyPeriodLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyMultiplierLeg1 != null ? interestRateResetFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyPeriodLeg2 != null ? interestRateResetFrequencyPeriodLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyMultiplierLeg2 != null ? interestRateResetFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePrice != null ? interestRatePrice.hashCode() : 0);
			_result = 31 * _result + (fXCurrency1 != null ? fXCurrency1.hashCode() : 0);
			_result = 31 * _result + (fXCurrency2 != null ? fXCurrency2.hashCode() : 0);
			_result = 31 * _result + (fXExchangeRate != null ? fXExchangeRate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASSFATransactionReport {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"priorUniqueTransactionIdentifier=" + this.priorUniqueTransactionIdentifier + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"cleared=" + this.cleared + ", " +
				"clearedEntity=" + this.clearedEntity + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"terminationDate=" + this.terminationDate + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"optionType=" + this.optionType + ", " +
				"optionExpirationDate=" + this.optionExpirationDate + ", " +
				"optionPremium=" + this.optionPremium + ", " +
				"interestRateNotionalAmountLeg1=" + this.interestRateNotionalAmountLeg1 + ", " +
				"interestRateNotionalCurrencyLeg1=" + this.interestRateNotionalCurrencyLeg1 + ", " +
				"interestRateNotionalAmountLeg2=" + this.interestRateNotionalAmountLeg2 + ", " +
				"interestRateNotionalCurrencyLeg2=" + this.interestRateNotionalCurrencyLeg2 + ", " +
				"interestRatePayerLeg1=" + this.interestRatePayerLeg1 + ", " +
				"interestRatePayerLeg2=" + this.interestRatePayerLeg2 + ", " +
				"interestRateRateLeg1=" + this.interestRateRateLeg1 + ", " +
				"interestRateRateLeg2=" + this.interestRateRateLeg2 + ", " +
				"interestRatePaymentFrequencyPeriodLeg1=" + this.interestRatePaymentFrequencyPeriodLeg1 + ", " +
				"interestRatePaymentFrequencyMultiplierLeg1=" + this.interestRatePaymentFrequencyMultiplierLeg1 + ", " +
				"interestRatePaymentFrequencyPeriodLeg2=" + this.interestRatePaymentFrequencyPeriodLeg2 + ", " +
				"interestRatePaymentFrequencyMultiplierLeg2=" + this.interestRatePaymentFrequencyMultiplierLeg2 + ", " +
				"interestRateDayCountLeg1=" + this.interestRateDayCountLeg1 + ", " +
				"interestRateDayCountLeg2=" + this.interestRateDayCountLeg2 + ", " +
				"interestRateResetFrequencyPeriodLeg1=" + this.interestRateResetFrequencyPeriodLeg1 + ", " +
				"interestRateResetFrequencyMultiplierLeg1=" + this.interestRateResetFrequencyMultiplierLeg1 + ", " +
				"interestRateResetFrequencyPeriodLeg2=" + this.interestRateResetFrequencyPeriodLeg2 + ", " +
				"interestRateResetFrequencyMultiplierLeg2=" + this.interestRateResetFrequencyMultiplierLeg2 + ", " +
				"interestRatePrice=" + this.interestRatePrice + ", " +
				"fXCurrency1=" + this.fXCurrency1 + ", " +
				"fXCurrency2=" + this.fXCurrency2 + ", " +
				"fXExchangeRate=" + this.fXExchangeRate +
			'}';
		}
	}

	/*********************** Builder Implementation of MASSFATransactionReport  ***********************/
	class MASSFATransactionReportBuilderImpl implements MASSFATransactionReport.MASSFATransactionReportBuilder {
	
		protected String uniqueTransactionIdentifier;
		protected String uniqueProductIdentifier;
		protected String priorUniqueTransactionIdentifier;
		protected String counterparty1;
		protected String counterparty2;
		protected String reportingEntity;
		protected String cleared;
		protected String clearedEntity;
		protected Date effectiveDate;
		protected Date terminationDate;
		protected ZonedDateTime reportingTimestamp;
		protected String optionType;
		protected String optionExpirationDate;
		protected String optionPremium;
		protected BigDecimal interestRateNotionalAmountLeg1;
		protected String interestRateNotionalCurrencyLeg1;
		protected BigDecimal interestRateNotionalAmountLeg2;
		protected String interestRateNotionalCurrencyLeg2;
		protected String interestRatePayerLeg1;
		protected String interestRatePayerLeg2;
		protected BigDecimal interestRateRateLeg1;
		protected BigDecimal interestRateRateLeg2;
		protected PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg1;
		protected Integer interestRatePaymentFrequencyMultiplierLeg1;
		protected PeriodExtendedEnum interestRatePaymentFrequencyPeriodLeg2;
		protected Integer interestRatePaymentFrequencyMultiplierLeg2;
		protected DayCountFractionEnum interestRateDayCountLeg1;
		protected DayCountFractionEnum interestRateDayCountLeg2;
		protected PeriodExtendedEnum interestRateResetFrequencyPeriodLeg1;
		protected Integer interestRateResetFrequencyMultiplierLeg1;
		protected PeriodExtendedEnum interestRateResetFrequencyPeriodLeg2;
		protected Integer interestRateResetFrequencyMultiplierLeg2;
		protected BigDecimal interestRatePrice;
		protected String fXCurrency1;
		protected String fXCurrency2;
		protected BigDecimal fXExchangeRate;
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("priorUniqueTransactionIdentifier")
		@RuneAttribute("priorUniqueTransactionIdentifier")
		public String getPriorUniqueTransactionIdentifier() {
			return priorUniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearedEntity")
		@RuneAttribute("clearedEntity")
		public String getClearedEntity() {
			return clearedEntity;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("terminationDate")
		@RuneAttribute("terminationDate")
		public Date getTerminationDate() {
			return terminationDate;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionExpirationDate")
		@RuneAttribute("optionExpirationDate")
		public String getOptionExpirationDate() {
			return optionExpirationDate;
		}
		
		@Override
		@RosettaAttribute("optionPremium")
		@RuneAttribute("optionPremium")
		public String getOptionPremium() {
			return optionPremium;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg1")
		@RuneAttribute("interestRateNotionalAmountLeg1")
		public BigDecimal getInterestRateNotionalAmountLeg1() {
			return interestRateNotionalAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg1")
		@RuneAttribute("interestRateNotionalCurrencyLeg1")
		public String getInterestRateNotionalCurrencyLeg1() {
			return interestRateNotionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg2")
		@RuneAttribute("interestRateNotionalAmountLeg2")
		public BigDecimal getInterestRateNotionalAmountLeg2() {
			return interestRateNotionalAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg2")
		@RuneAttribute("interestRateNotionalCurrencyLeg2")
		public String getInterestRateNotionalCurrencyLeg2() {
			return interestRateNotionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg1")
		@RuneAttribute("interestRatePayerLeg1")
		public String getInterestRatePayerLeg1() {
			return interestRatePayerLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg2")
		@RuneAttribute("interestRatePayerLeg2")
		public String getInterestRatePayerLeg2() {
			return interestRatePayerLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg1")
		@RuneAttribute("interestRateRateLeg1")
		public BigDecimal getInterestRateRateLeg1() {
			return interestRateRateLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg2")
		@RuneAttribute("interestRateRateLeg2")
		public BigDecimal getInterestRateRateLeg2() {
			return interestRateRateLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg1")
		public PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg1() {
			return interestRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		public Integer getInterestRatePaymentFrequencyMultiplierLeg1() {
			return interestRatePaymentFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg2")
		public PeriodExtendedEnum getInterestRatePaymentFrequencyPeriodLeg2() {
			return interestRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		public Integer getInterestRatePaymentFrequencyMultiplierLeg2() {
			return interestRatePaymentFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg1")
		@RuneAttribute("interestRateDayCountLeg1")
		public DayCountFractionEnum getInterestRateDayCountLeg1() {
			return interestRateDayCountLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg2")
		@RuneAttribute("interestRateDayCountLeg2")
		public DayCountFractionEnum getInterestRateDayCountLeg2() {
			return interestRateDayCountLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg1")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg1")
		public PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg1() {
			return interestRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg1")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg1")
		public Integer getInterestRateResetFrequencyMultiplierLeg1() {
			return interestRateResetFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg2")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg2")
		public PeriodExtendedEnum getInterestRateResetFrequencyPeriodLeg2() {
			return interestRateResetFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg2")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg2")
		public Integer getInterestRateResetFrequencyMultiplierLeg2() {
			return interestRateResetFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("interestRatePrice")
		@RuneAttribute("interestRatePrice")
		public BigDecimal getInterestRatePrice() {
			return interestRatePrice;
		}
		
		@Override
		@RosettaAttribute("fXCurrency1")
		@RuneAttribute("fXCurrency1")
		public String getFXCurrency1() {
			return fXCurrency1;
		}
		
		@Override
		@RosettaAttribute("fXCurrency2")
		@RuneAttribute("fXCurrency2")
		public String getFXCurrency2() {
			return fXCurrency2;
		}
		
		@Override
		@RosettaAttribute("fXExchangeRate")
		@RuneAttribute("fXExchangeRate")
		public BigDecimal getFXExchangeRate() {
			return fXExchangeRate;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUniqueTransactionIdentifier")
		@RuneAttribute("priorUniqueTransactionIdentifier")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setPriorUniqueTransactionIdentifier(String _priorUniqueTransactionIdentifier) {
			this.priorUniqueTransactionIdentifier = _priorUniqueTransactionIdentifier == null ? null : _priorUniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setReportingEntity(String _reportingEntity) {
			this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearedEntity")
		@RuneAttribute("clearedEntity")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setClearedEntity(String _clearedEntity) {
			this.clearedEntity = _clearedEntity == null ? null : _clearedEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("terminationDate")
		@RuneAttribute("terminationDate")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setTerminationDate(Date _terminationDate) {
			this.terminationDate = _terminationDate == null ? null : _terminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionExpirationDate")
		@RuneAttribute("optionExpirationDate")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setOptionExpirationDate(String _optionExpirationDate) {
			this.optionExpirationDate = _optionExpirationDate == null ? null : _optionExpirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremium")
		@RuneAttribute("optionPremium")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setOptionPremium(String _optionPremium) {
			this.optionPremium = _optionPremium == null ? null : _optionPremium;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg1")
		@RuneAttribute("interestRateNotionalAmountLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalAmountLeg1(BigDecimal _interestRateNotionalAmountLeg1) {
			this.interestRateNotionalAmountLeg1 = _interestRateNotionalAmountLeg1 == null ? null : _interestRateNotionalAmountLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg1")
		@RuneAttribute("interestRateNotionalCurrencyLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalCurrencyLeg1(String _interestRateNotionalCurrencyLeg1) {
			this.interestRateNotionalCurrencyLeg1 = _interestRateNotionalCurrencyLeg1 == null ? null : _interestRateNotionalCurrencyLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalAmountLeg2")
		@RuneAttribute("interestRateNotionalAmountLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalAmountLeg2(BigDecimal _interestRateNotionalAmountLeg2) {
			this.interestRateNotionalAmountLeg2 = _interestRateNotionalAmountLeg2 == null ? null : _interestRateNotionalAmountLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateNotionalCurrencyLeg2")
		@RuneAttribute("interestRateNotionalCurrencyLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateNotionalCurrencyLeg2(String _interestRateNotionalCurrencyLeg2) {
			this.interestRateNotionalCurrencyLeg2 = _interestRateNotionalCurrencyLeg2 == null ? null : _interestRateNotionalCurrencyLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg1")
		@RuneAttribute("interestRatePayerLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePayerLeg1(String _interestRatePayerLeg1) {
			this.interestRatePayerLeg1 = _interestRatePayerLeg1 == null ? null : _interestRatePayerLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePayerLeg2")
		@RuneAttribute("interestRatePayerLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePayerLeg2(String _interestRatePayerLeg2) {
			this.interestRatePayerLeg2 = _interestRatePayerLeg2 == null ? null : _interestRatePayerLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg1")
		@RuneAttribute("interestRateRateLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateRateLeg1(BigDecimal _interestRateRateLeg1) {
			this.interestRateRateLeg1 = _interestRateRateLeg1 == null ? null : _interestRateRateLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateRateLeg2")
		@RuneAttribute("interestRateRateLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateRateLeg2(BigDecimal _interestRateRateLeg2) {
			this.interestRateRateLeg2 = _interestRateRateLeg2 == null ? null : _interestRateRateLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyPeriodLeg1(PeriodExtendedEnum _interestRatePaymentFrequencyPeriodLeg1) {
			this.interestRatePaymentFrequencyPeriodLeg1 = _interestRatePaymentFrequencyPeriodLeg1 == null ? null : _interestRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyMultiplierLeg1(Integer _interestRatePaymentFrequencyMultiplierLeg1) {
			this.interestRatePaymentFrequencyMultiplierLeg1 = _interestRatePaymentFrequencyMultiplierLeg1 == null ? null : _interestRatePaymentFrequencyMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("interestRatePaymentFrequencyPeriodLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyPeriodLeg2(PeriodExtendedEnum _interestRatePaymentFrequencyPeriodLeg2) {
			this.interestRatePaymentFrequencyPeriodLeg2 = _interestRatePaymentFrequencyPeriodLeg2 == null ? null : _interestRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		@RuneAttribute("interestRatePaymentFrequencyMultiplierLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePaymentFrequencyMultiplierLeg2(Integer _interestRatePaymentFrequencyMultiplierLeg2) {
			this.interestRatePaymentFrequencyMultiplierLeg2 = _interestRatePaymentFrequencyMultiplierLeg2 == null ? null : _interestRatePaymentFrequencyMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg1")
		@RuneAttribute("interestRateDayCountLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateDayCountLeg1(DayCountFractionEnum _interestRateDayCountLeg1) {
			this.interestRateDayCountLeg1 = _interestRateDayCountLeg1 == null ? null : _interestRateDayCountLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateDayCountLeg2")
		@RuneAttribute("interestRateDayCountLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateDayCountLeg2(DayCountFractionEnum _interestRateDayCountLeg2) {
			this.interestRateDayCountLeg2 = _interestRateDayCountLeg2 == null ? null : _interestRateDayCountLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg1")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyPeriodLeg1(PeriodExtendedEnum _interestRateResetFrequencyPeriodLeg1) {
			this.interestRateResetFrequencyPeriodLeg1 = _interestRateResetFrequencyPeriodLeg1 == null ? null : _interestRateResetFrequencyPeriodLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg1")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyMultiplierLeg1(Integer _interestRateResetFrequencyMultiplierLeg1) {
			this.interestRateResetFrequencyMultiplierLeg1 = _interestRateResetFrequencyMultiplierLeg1 == null ? null : _interestRateResetFrequencyMultiplierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyPeriodLeg2")
		@RuneAttribute("interestRateResetFrequencyPeriodLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyPeriodLeg2(PeriodExtendedEnum _interestRateResetFrequencyPeriodLeg2) {
			this.interestRateResetFrequencyPeriodLeg2 = _interestRateResetFrequencyPeriodLeg2 == null ? null : _interestRateResetFrequencyPeriodLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRateResetFrequencyMultiplierLeg2")
		@RuneAttribute("interestRateResetFrequencyMultiplierLeg2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRateResetFrequencyMultiplierLeg2(Integer _interestRateResetFrequencyMultiplierLeg2) {
			this.interestRateResetFrequencyMultiplierLeg2 = _interestRateResetFrequencyMultiplierLeg2 == null ? null : _interestRateResetFrequencyMultiplierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("interestRatePrice")
		@RuneAttribute("interestRatePrice")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setInterestRatePrice(BigDecimal _interestRatePrice) {
			this.interestRatePrice = _interestRatePrice == null ? null : _interestRatePrice;
			return this;
		}
		
		@Override
		@RosettaAttribute("fXCurrency1")
		@RuneAttribute("fXCurrency1")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setFXCurrency1(String _fXCurrency1) {
			this.fXCurrency1 = _fXCurrency1 == null ? null : _fXCurrency1;
			return this;
		}
		
		@Override
		@RosettaAttribute("fXCurrency2")
		@RuneAttribute("fXCurrency2")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setFXCurrency2(String _fXCurrency2) {
			this.fXCurrency2 = _fXCurrency2 == null ? null : _fXCurrency2;
			return this;
		}
		
		@Override
		@RosettaAttribute("fXExchangeRate")
		@RuneAttribute("fXExchangeRate")
		public MASSFATransactionReport.MASSFATransactionReportBuilder setFXExchangeRate(BigDecimal _fXExchangeRate) {
			this.fXExchangeRate = _fXExchangeRate == null ? null : _fXExchangeRate;
			return this;
		}
		
		@Override
		public MASSFATransactionReport build() {
			return new MASSFATransactionReport.MASSFATransactionReportImpl(this);
		}
		
		@Override
		public MASSFATransactionReport.MASSFATransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASSFATransactionReport.MASSFATransactionReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUniqueProductIdentifier()!=null) return true;
			if (getPriorUniqueTransactionIdentifier()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getReportingEntity()!=null) return true;
			if (getCleared()!=null) return true;
			if (getClearedEntity()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getTerminationDate()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getOptionType()!=null) return true;
			if (getOptionExpirationDate()!=null) return true;
			if (getOptionPremium()!=null) return true;
			if (getInterestRateNotionalAmountLeg1()!=null) return true;
			if (getInterestRateNotionalCurrencyLeg1()!=null) return true;
			if (getInterestRateNotionalAmountLeg2()!=null) return true;
			if (getInterestRateNotionalCurrencyLeg2()!=null) return true;
			if (getInterestRatePayerLeg1()!=null) return true;
			if (getInterestRatePayerLeg2()!=null) return true;
			if (getInterestRateRateLeg1()!=null) return true;
			if (getInterestRateRateLeg2()!=null) return true;
			if (getInterestRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getInterestRatePaymentFrequencyMultiplierLeg1()!=null) return true;
			if (getInterestRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getInterestRatePaymentFrequencyMultiplierLeg2()!=null) return true;
			if (getInterestRateDayCountLeg1()!=null) return true;
			if (getInterestRateDayCountLeg2()!=null) return true;
			if (getInterestRateResetFrequencyPeriodLeg1()!=null) return true;
			if (getInterestRateResetFrequencyMultiplierLeg1()!=null) return true;
			if (getInterestRateResetFrequencyPeriodLeg2()!=null) return true;
			if (getInterestRateResetFrequencyMultiplierLeg2()!=null) return true;
			if (getInterestRatePrice()!=null) return true;
			if (getFXCurrency1()!=null) return true;
			if (getFXCurrency2()!=null) return true;
			if (getFXExchangeRate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASSFATransactionReport.MASSFATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			MASSFATransactionReport.MASSFATransactionReportBuilder o = (MASSFATransactionReport.MASSFATransactionReportBuilder) other;
			
			
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUniqueProductIdentifier(), o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier);
			merger.mergeBasic(getPriorUniqueTransactionIdentifier(), o.getPriorUniqueTransactionIdentifier(), this::setPriorUniqueTransactionIdentifier);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getReportingEntity(), o.getReportingEntity(), this::setReportingEntity);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getClearedEntity(), o.getClearedEntity(), this::setClearedEntity);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getTerminationDate(), o.getTerminationDate(), this::setTerminationDate);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getOptionExpirationDate(), o.getOptionExpirationDate(), this::setOptionExpirationDate);
			merger.mergeBasic(getOptionPremium(), o.getOptionPremium(), this::setOptionPremium);
			merger.mergeBasic(getInterestRateNotionalAmountLeg1(), o.getInterestRateNotionalAmountLeg1(), this::setInterestRateNotionalAmountLeg1);
			merger.mergeBasic(getInterestRateNotionalCurrencyLeg1(), o.getInterestRateNotionalCurrencyLeg1(), this::setInterestRateNotionalCurrencyLeg1);
			merger.mergeBasic(getInterestRateNotionalAmountLeg2(), o.getInterestRateNotionalAmountLeg2(), this::setInterestRateNotionalAmountLeg2);
			merger.mergeBasic(getInterestRateNotionalCurrencyLeg2(), o.getInterestRateNotionalCurrencyLeg2(), this::setInterestRateNotionalCurrencyLeg2);
			merger.mergeBasic(getInterestRatePayerLeg1(), o.getInterestRatePayerLeg1(), this::setInterestRatePayerLeg1);
			merger.mergeBasic(getInterestRatePayerLeg2(), o.getInterestRatePayerLeg2(), this::setInterestRatePayerLeg2);
			merger.mergeBasic(getInterestRateRateLeg1(), o.getInterestRateRateLeg1(), this::setInterestRateRateLeg1);
			merger.mergeBasic(getInterestRateRateLeg2(), o.getInterestRateRateLeg2(), this::setInterestRateRateLeg2);
			merger.mergeBasic(getInterestRatePaymentFrequencyPeriodLeg1(), o.getInterestRatePaymentFrequencyPeriodLeg1(), this::setInterestRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getInterestRatePaymentFrequencyMultiplierLeg1(), o.getInterestRatePaymentFrequencyMultiplierLeg1(), this::setInterestRatePaymentFrequencyMultiplierLeg1);
			merger.mergeBasic(getInterestRatePaymentFrequencyPeriodLeg2(), o.getInterestRatePaymentFrequencyPeriodLeg2(), this::setInterestRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getInterestRatePaymentFrequencyMultiplierLeg2(), o.getInterestRatePaymentFrequencyMultiplierLeg2(), this::setInterestRatePaymentFrequencyMultiplierLeg2);
			merger.mergeBasic(getInterestRateDayCountLeg1(), o.getInterestRateDayCountLeg1(), this::setInterestRateDayCountLeg1);
			merger.mergeBasic(getInterestRateDayCountLeg2(), o.getInterestRateDayCountLeg2(), this::setInterestRateDayCountLeg2);
			merger.mergeBasic(getInterestRateResetFrequencyPeriodLeg1(), o.getInterestRateResetFrequencyPeriodLeg1(), this::setInterestRateResetFrequencyPeriodLeg1);
			merger.mergeBasic(getInterestRateResetFrequencyMultiplierLeg1(), o.getInterestRateResetFrequencyMultiplierLeg1(), this::setInterestRateResetFrequencyMultiplierLeg1);
			merger.mergeBasic(getInterestRateResetFrequencyPeriodLeg2(), o.getInterestRateResetFrequencyPeriodLeg2(), this::setInterestRateResetFrequencyPeriodLeg2);
			merger.mergeBasic(getInterestRateResetFrequencyMultiplierLeg2(), o.getInterestRateResetFrequencyMultiplierLeg2(), this::setInterestRateResetFrequencyMultiplierLeg2);
			merger.mergeBasic(getInterestRatePrice(), o.getInterestRatePrice(), this::setInterestRatePrice);
			merger.mergeBasic(getFXCurrency1(), o.getFXCurrency1(), this::setFXCurrency1);
			merger.mergeBasic(getFXCurrency2(), o.getFXCurrency2(), this::setFXCurrency2);
			merger.mergeBasic(getFXExchangeRate(), o.getFXExchangeRate(), this::setFXExchangeRate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASSFATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(priorUniqueTransactionIdentifier, _that.getPriorUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearedEntity, _that.getClearedEntity())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(terminationDate, _that.getTerminationDate())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionExpirationDate, _that.getOptionExpirationDate())) return false;
			if (!Objects.equals(optionPremium, _that.getOptionPremium())) return false;
			if (!Objects.equals(interestRateNotionalAmountLeg1, _that.getInterestRateNotionalAmountLeg1())) return false;
			if (!Objects.equals(interestRateNotionalCurrencyLeg1, _that.getInterestRateNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(interestRateNotionalAmountLeg2, _that.getInterestRateNotionalAmountLeg2())) return false;
			if (!Objects.equals(interestRateNotionalCurrencyLeg2, _that.getInterestRateNotionalCurrencyLeg2())) return false;
			if (!Objects.equals(interestRatePayerLeg1, _that.getInterestRatePayerLeg1())) return false;
			if (!Objects.equals(interestRatePayerLeg2, _that.getInterestRatePayerLeg2())) return false;
			if (!Objects.equals(interestRateRateLeg1, _that.getInterestRateRateLeg1())) return false;
			if (!Objects.equals(interestRateRateLeg2, _that.getInterestRateRateLeg2())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyPeriodLeg1, _that.getInterestRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyMultiplierLeg1, _that.getInterestRatePaymentFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyPeriodLeg2, _that.getInterestRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(interestRatePaymentFrequencyMultiplierLeg2, _that.getInterestRatePaymentFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(interestRateDayCountLeg1, _that.getInterestRateDayCountLeg1())) return false;
			if (!Objects.equals(interestRateDayCountLeg2, _that.getInterestRateDayCountLeg2())) return false;
			if (!Objects.equals(interestRateResetFrequencyPeriodLeg1, _that.getInterestRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(interestRateResetFrequencyMultiplierLeg1, _that.getInterestRateResetFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(interestRateResetFrequencyPeriodLeg2, _that.getInterestRateResetFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(interestRateResetFrequencyMultiplierLeg2, _that.getInterestRateResetFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(interestRatePrice, _that.getInterestRatePrice())) return false;
			if (!Objects.equals(fXCurrency1, _that.getFXCurrency1())) return false;
			if (!Objects.equals(fXCurrency2, _that.getFXCurrency2())) return false;
			if (!Objects.equals(fXExchangeRate, _that.getFXExchangeRate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (priorUniqueTransactionIdentifier != null ? priorUniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearedEntity != null ? clearedEntity.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (terminationDate != null ? terminationDate.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionExpirationDate != null ? optionExpirationDate.hashCode() : 0);
			_result = 31 * _result + (optionPremium != null ? optionPremium.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalAmountLeg1 != null ? interestRateNotionalAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalCurrencyLeg1 != null ? interestRateNotionalCurrencyLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalAmountLeg2 != null ? interestRateNotionalAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateNotionalCurrencyLeg2 != null ? interestRateNotionalCurrencyLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePayerLeg1 != null ? interestRatePayerLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRatePayerLeg2 != null ? interestRatePayerLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateRateLeg1 != null ? interestRateRateLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateRateLeg2 != null ? interestRateRateLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyPeriodLeg1 != null ? interestRatePaymentFrequencyPeriodLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyMultiplierLeg1 != null ? interestRatePaymentFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyPeriodLeg2 != null ? interestRatePaymentFrequencyPeriodLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRatePaymentFrequencyMultiplierLeg2 != null ? interestRatePaymentFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRateDayCountLeg1 != null ? interestRateDayCountLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateDayCountLeg2 != null ? interestRateDayCountLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyPeriodLeg1 != null ? interestRateResetFrequencyPeriodLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyMultiplierLeg1 != null ? interestRateResetFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyPeriodLeg2 != null ? interestRateResetFrequencyPeriodLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (interestRateResetFrequencyMultiplierLeg2 != null ? interestRateResetFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (interestRatePrice != null ? interestRatePrice.hashCode() : 0);
			_result = 31 * _result + (fXCurrency1 != null ? fXCurrency1.hashCode() : 0);
			_result = 31 * _result + (fXCurrency2 != null ? fXCurrency2.hashCode() : 0);
			_result = 31 * _result + (fXExchangeRate != null ? fXExchangeRate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASSFATransactionReportBuilder {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"priorUniqueTransactionIdentifier=" + this.priorUniqueTransactionIdentifier + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"cleared=" + this.cleared + ", " +
				"clearedEntity=" + this.clearedEntity + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"terminationDate=" + this.terminationDate + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"optionType=" + this.optionType + ", " +
				"optionExpirationDate=" + this.optionExpirationDate + ", " +
				"optionPremium=" + this.optionPremium + ", " +
				"interestRateNotionalAmountLeg1=" + this.interestRateNotionalAmountLeg1 + ", " +
				"interestRateNotionalCurrencyLeg1=" + this.interestRateNotionalCurrencyLeg1 + ", " +
				"interestRateNotionalAmountLeg2=" + this.interestRateNotionalAmountLeg2 + ", " +
				"interestRateNotionalCurrencyLeg2=" + this.interestRateNotionalCurrencyLeg2 + ", " +
				"interestRatePayerLeg1=" + this.interestRatePayerLeg1 + ", " +
				"interestRatePayerLeg2=" + this.interestRatePayerLeg2 + ", " +
				"interestRateRateLeg1=" + this.interestRateRateLeg1 + ", " +
				"interestRateRateLeg2=" + this.interestRateRateLeg2 + ", " +
				"interestRatePaymentFrequencyPeriodLeg1=" + this.interestRatePaymentFrequencyPeriodLeg1 + ", " +
				"interestRatePaymentFrequencyMultiplierLeg1=" + this.interestRatePaymentFrequencyMultiplierLeg1 + ", " +
				"interestRatePaymentFrequencyPeriodLeg2=" + this.interestRatePaymentFrequencyPeriodLeg2 + ", " +
				"interestRatePaymentFrequencyMultiplierLeg2=" + this.interestRatePaymentFrequencyMultiplierLeg2 + ", " +
				"interestRateDayCountLeg1=" + this.interestRateDayCountLeg1 + ", " +
				"interestRateDayCountLeg2=" + this.interestRateDayCountLeg2 + ", " +
				"interestRateResetFrequencyPeriodLeg1=" + this.interestRateResetFrequencyPeriodLeg1 + ", " +
				"interestRateResetFrequencyMultiplierLeg1=" + this.interestRateResetFrequencyMultiplierLeg1 + ", " +
				"interestRateResetFrequencyPeriodLeg2=" + this.interestRateResetFrequencyPeriodLeg2 + ", " +
				"interestRateResetFrequencyMultiplierLeg2=" + this.interestRateResetFrequencyMultiplierLeg2 + ", " +
				"interestRatePrice=" + this.interestRatePrice + ", " +
				"fXCurrency1=" + this.fXCurrency1 + ", " +
				"fXCurrency2=" + this.fXCurrency2 + ", " +
				"fXExchangeRate=" + this.fXExchangeRate +
			'}';
		}
	}
}
