package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaFloatingRateOption;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsInterestRateSpread;
import drr.regulation.common.functions.SingleTradeLot;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FixedFloatRateLeg2Rule.FixedFloatRateLeg2RuleDefault.class)
public abstract class FixedFloatRateLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ContractForEventRule contractForEventRule;
	@Inject protected IsInterestRatePayoutRule isInterestRatePayoutRule;
	@Inject protected IsInterestRateSpread isInterestRateSpread;
	@Inject protected SingleTradeLot singleTradeLot;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FixedFloatRateLeg2RuleDefault extends FixedFloatRateLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isInterestRatePayoutRule.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(contractForEventRule.evaluate(item.get())));
			final MapperS<TradeLot> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(singleTradeLot.evaluate(item.get())));
			final MapperC<PriceQuantity> thenArg3 = thenArg2
				.mapSingleToList(item -> item.<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()));
			final MapperC<PriceQuantity> thenArg4 = thenArg3
				.filterItemNullSafe(item -> notExists(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaFloatingRateOption>map("getRateOption", observable -> observable.getRateOption())).get());
			final MapperListOfLists<FieldWithMetaPriceSchedule> thenArg5 = thenArg4
				.mapItemToList(item -> item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
			final MapperC<FieldWithMetaPriceSchedule> thenArg6 = thenArg5
				.flattenList();
			final MapperC<FieldWithMetaPriceSchedule> thenArg7 = thenArg6
				.filterItemNullSafe(item -> {
					final FieldWithMetaPriceSchedule fieldWithMetaPriceSchedule = item.get();
					return isInterestRateSpread.evaluate((fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()));
				});
			final MapperS<FieldWithMetaPriceSchedule> thenArg8 = MapperS.of(thenArg7.get());
			output = thenArg8
				.mapSingleToItem(item -> item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue())).get();
			
			return output;
		}
	}
}
