package drr.regulation.techsprint.g20.mas.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport.MASSFATransactionReportBuilder;
import drr.regulation.techsprint.g20.mas.labels.MASSFAMAS_2013LabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.techsprint.g20.mas", body="MAS", corpusList={"SFA", "MAS_2013"})
@RuneLabelProvider(labelProvider=MASSFAMAS_2013LabelProvider.class)
@ImplementedBy(MASSFAMAS_2013ReportFunction.MASSFAMAS_2013ReportFunctionDefault.class)
public abstract class MASSFAMAS_2013ReportFunction implements ReportFunction<TransactionReportInstruction, MASSFATransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ClearedEntityRule clearedEntityRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected FXCurrency1Rule fXCurrency1Rule;
	@Inject protected FXCurrency2Rule fXCurrency2Rule;
	@Inject protected FXExchangeRateRule fXExchangeRateRule;
	@Inject protected InterestRateDayCountLeg1Rule interestRateDayCountLeg1Rule;
	@Inject protected InterestRateDayCountLeg2Rule interestRateDayCountLeg2Rule;
	@Inject protected InterestRateNotionalAmountLeg1Rule interestRateNotionalAmountLeg1Rule;
	@Inject protected InterestRateNotionalAmountLeg2Rule interestRateNotionalAmountLeg2Rule;
	@Inject protected InterestRateNotionalCurrencyLeg1Rule interestRateNotionalCurrencyLeg1Rule;
	@Inject protected InterestRateNotionalCurrencyLeg2Rule interestRateNotionalCurrencyLeg2Rule;
	@Inject protected InterestRatePayerLeg1Rule interestRatePayerLeg1Rule;
	@Inject protected InterestRatePayerLeg2Rule interestRatePayerLeg2Rule;
	@Inject protected InterestRatePaymentFrequencyMultiplierLeg1Rule interestRatePaymentFrequencyMultiplierLeg1Rule;
	@Inject protected InterestRatePaymentFrequencyMultiplierLeg2Rule interestRatePaymentFrequencyMultiplierLeg2Rule;
	@Inject protected InterestRatePaymentFrequencyPeriodLeg1Rule interestRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected InterestRatePaymentFrequencyPeriodLeg2Rule interestRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected InterestRatePriceRule interestRatePriceRule;
	@Inject protected InterestRateRateLeg1Rule interestRateRateLeg1Rule;
	@Inject protected InterestRateRateLeg2Rule interestRateRateLeg2Rule;
	@Inject protected InterestRateResetFrequencyMultiplierLeg1Rule interestRateResetFrequencyMultiplierLeg1Rule;
	@Inject protected InterestRateResetFrequencyMultiplierLeg2Rule interestRateResetFrequencyMultiplierLeg2Rule;
	@Inject protected InterestRateResetFrequencyPeriodLeg1Rule interestRateResetFrequencyPeriodLeg1Rule;
	@Inject protected InterestRateResetFrequencyPeriodLeg2Rule interestRateResetFrequencyPeriodLeg2Rule;
	@Inject protected OptionExpirationDateRule optionExpirationDateRule;
	@Inject protected OptionPremiumRule optionPremiumRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected PriorUniqueTransactionIdentifierRule priorUniqueTransactionIdentifierRule;
	@Inject protected ReportingEntityRule reportingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected TerminationDateRule terminationDateRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public MASSFATransactionReport evaluate(TransactionReportInstruction input) {
		MASSFATransactionReport.MASSFATransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final MASSFATransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(MASSFATransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract MASSFATransactionReport.MASSFATransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class MASSFAMAS_2013ReportFunctionDefault extends MASSFAMAS_2013ReportFunction {
		@Override
		protected MASSFATransactionReport.MASSFATransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			MASSFATransactionReport.MASSFATransactionReportBuilder output = MASSFATransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected MASSFATransactionReport.MASSFATransactionReportBuilder assignOutput(MASSFATransactionReport.MASSFATransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setPriorUniqueTransactionIdentifier(priorUniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setReportingEntity(reportingEntityRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setClearedEntity(clearedEntityRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setTerminationDate(terminationDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setOptionExpirationDate(optionExpirationDateRule.evaluate(input));
			
			output
				.setOptionPremium(optionPremiumRule.evaluate(input));
			
			output
				.setInterestRateNotionalAmountLeg1(interestRateNotionalAmountLeg1Rule.evaluate(input));
			
			output
				.setInterestRateNotionalCurrencyLeg1(interestRateNotionalCurrencyLeg1Rule.evaluate(input));
			
			output
				.setInterestRateNotionalAmountLeg2(interestRateNotionalAmountLeg2Rule.evaluate(input));
			
			output
				.setInterestRateNotionalCurrencyLeg2(interestRateNotionalCurrencyLeg2Rule.evaluate(input));
			
			output
				.setInterestRatePayerLeg1(interestRatePayerLeg1Rule.evaluate(input));
			
			output
				.setInterestRatePayerLeg2(interestRatePayerLeg2Rule.evaluate(input));
			
			output
				.setInterestRateRateLeg1(interestRateRateLeg1Rule.evaluate(input));
			
			output
				.setInterestRateRateLeg2(interestRateRateLeg2Rule.evaluate(input));
			
			output
				.setInterestRatePaymentFrequencyPeriodLeg1(interestRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setInterestRatePaymentFrequencyMultiplierLeg1(interestRatePaymentFrequencyMultiplierLeg1Rule.evaluate(input));
			
			output
				.setInterestRatePaymentFrequencyPeriodLeg2(interestRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.setInterestRatePaymentFrequencyMultiplierLeg2(interestRatePaymentFrequencyMultiplierLeg2Rule.evaluate(input));
			
			output
				.setInterestRateDayCountLeg1(interestRateDayCountLeg1Rule.evaluate(input));
			
			output
				.setInterestRateDayCountLeg2(interestRateDayCountLeg2Rule.evaluate(input));
			
			output
				.setInterestRateResetFrequencyPeriodLeg1(interestRateResetFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setInterestRateResetFrequencyMultiplierLeg1(interestRateResetFrequencyMultiplierLeg1Rule.evaluate(input));
			
			output
				.setInterestRateResetFrequencyPeriodLeg2(interestRateResetFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.setInterestRateResetFrequencyMultiplierLeg2(interestRateResetFrequencyMultiplierLeg2Rule.evaluate(input));
			
			output
				.setInterestRatePrice(interestRatePriceRule.evaluate(input));
			
			output
				.setFXCurrency1(fXCurrency1Rule.evaluate(input));
			
			output
				.setFXCurrency2(fXCurrency2Rule.evaluate(input));
			
			output
				.setFXExchangeRate(fXExchangeRateRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
