package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.Party.PartyBuilder;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ReportingPartyRule.ReportingPartyRuleDefault.class)
public abstract class ReportingPartyRule implements ReportFunction<TransactionReportInstruction, Party> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Party evaluate(TransactionReportInstruction input) {
		Party.PartyBuilder outputBuilder = doEvaluate(input);
		
		final Party output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Party.class, output);
		}
		
		return output;
	}

	protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction input);

	public static class ReportingPartyRuleDefault extends ReportingPartyRule {
		@Override
		protected Party.PartyBuilder doEvaluate(TransactionReportInstruction input) {
			Party.PartyBuilder output = Party.builder();
			return assignOutput(output, input);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, TransactionReportInstruction input) {
			output = toBuilder(MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.REPORTING_PARTY))).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
