package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.Identifier;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.Trader;
import drr.regulation.techsprint.g20.mas.Trader.TraderBuilder;
import drr.regulation.techsprint.g20.mas.functions.LookupTraderDetails;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(TraderAddressForUTIRule.TraderAddressForUTIRuleDefault.class)
public abstract class TraderAddressForUTIRule implements ReportFunction<TransactionReportInstruction, Trader> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected LookupTraderDetails lookupTraderDetails;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Trader evaluate(TransactionReportInstruction input) {
		Trader.TraderBuilder outputBuilder = doEvaluate(input);
		
		final Trader output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Trader.class, output);
		}
		
		return output;
	}

	protected abstract Trader.TraderBuilder doEvaluate(TransactionReportInstruction input);

	public static class TraderAddressForUTIRuleDefault extends TraderAddressForUTIRule {
		@Override
		protected Trader.TraderBuilder doEvaluate(TransactionReportInstruction input) {
			Trader.TraderBuilder output = Trader.builder();
			return assignOutput(output, input);
		}
		
		protected Trader.TraderBuilder assignOutput(Trader.TraderBuilder output, TransactionReportInstruction input) {
			final MapperC<AssignedIdentifier> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<Identifier>mapC("getEventIdentifier", workflowStep -> workflowStep.getEventIdentifier()).<AssignedIdentifier>mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()));
			final MapperC<Trader> thenArg1 = thenArg0
				.mapItem(item -> MapperS.of(lookupTraderDetails.evaluate(item.get())));
			output = toBuilder(thenArg1
				.last().get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
