package drr.regulation.techsprint.g20.mas.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class MASSFATransactionReportTypeFormatValidator implements Validator<MASSFATransactionReport> {

	private List<ComparisonResult> getComparisonResults(MASSFATransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("interestRatePaymentFrequencyMultiplierLeg1", o.getInterestRatePaymentFrequencyMultiplierLeg1(), empty(), of(0), empty(), empty()), 
				checkNumber("interestRatePaymentFrequencyMultiplierLeg2", o.getInterestRatePaymentFrequencyMultiplierLeg2(), empty(), of(0), empty(), empty()), 
				checkNumber("interestRateResetFrequencyMultiplierLeg1", o.getInterestRateResetFrequencyMultiplierLeg1(), empty(), of(0), empty(), empty()), 
				checkNumber("interestRateResetFrequencyMultiplierLeg2", o.getInterestRateResetFrequencyMultiplierLeg2(), empty(), of(0), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASSFATransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MASSFATransactionReport", ValidationType.TYPE_FORMAT, "MASSFATransactionReport", path, "", res.getError());
				}
				return success("MASSFATransactionReport", ValidationType.TYPE_FORMAT, "MASSFATransactionReport", path, "");
			})
			.collect(toList());
	}

}
