package drr.regulation.techsprint.g20.mas.validation;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class MASSFATransactionReportValidator implements Validator<MASSFATransactionReport> {

	private List<ComparisonResult> getComparisonResults(MASSFATransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueProductIdentifier", (String) o.getUniqueProductIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("priorUniqueTransactionIdentifier", (String) o.getPriorUniqueTransactionIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingEntity", (String) o.getReportingEntity() != null ? 1 : 0, 1, 1), 
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 1, 1), 
				checkCardinality("clearedEntity", (String) o.getClearedEntity() != null ? 1 : 0, 1, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("terminationDate", (Date) o.getTerminationDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("optionExpirationDate", (String) o.getOptionExpirationDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("optionPremium", (String) o.getOptionPremium() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateNotionalAmountLeg1", (BigDecimal) o.getInterestRateNotionalAmountLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateNotionalCurrencyLeg1", (String) o.getInterestRateNotionalCurrencyLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateNotionalAmountLeg2", (BigDecimal) o.getInterestRateNotionalAmountLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateNotionalCurrencyLeg2", (String) o.getInterestRateNotionalCurrencyLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePayerLeg1", (String) o.getInterestRatePayerLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePayerLeg2", (String) o.getInterestRatePayerLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateRateLeg1", (BigDecimal) o.getInterestRateRateLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateRateLeg2", (BigDecimal) o.getInterestRateRateLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePaymentFrequencyPeriodLeg1", (PeriodExtendedEnum) o.getInterestRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePaymentFrequencyMultiplierLeg1", (Integer) o.getInterestRatePaymentFrequencyMultiplierLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePaymentFrequencyPeriodLeg2", (PeriodExtendedEnum) o.getInterestRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePaymentFrequencyMultiplierLeg2", (Integer) o.getInterestRatePaymentFrequencyMultiplierLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateDayCountLeg1", (DayCountFractionEnum) o.getInterestRateDayCountLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateDayCountLeg2", (DayCountFractionEnum) o.getInterestRateDayCountLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateResetFrequencyPeriodLeg1", (PeriodExtendedEnum) o.getInterestRateResetFrequencyPeriodLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateResetFrequencyMultiplierLeg1", (Integer) o.getInterestRateResetFrequencyMultiplierLeg1() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateResetFrequencyPeriodLeg2", (PeriodExtendedEnum) o.getInterestRateResetFrequencyPeriodLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRateResetFrequencyMultiplierLeg2", (Integer) o.getInterestRateResetFrequencyMultiplierLeg2() != null ? 1 : 0, 1, 1), 
				checkCardinality("interestRatePrice", (BigDecimal) o.getInterestRatePrice() != null ? 1 : 0, 1, 1), 
				checkCardinality("fXCurrency1", (String) o.getFXCurrency1() != null ? 1 : 0, 1, 1), 
				checkCardinality("fXCurrency2", (String) o.getFXCurrency2() != null ? 1 : 0, 1, 1), 
				checkCardinality("fXExchangeRate", (BigDecimal) o.getFXExchangeRate() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASSFATransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MASSFATransactionReport", ValidationType.CARDINALITY, "MASSFATransactionReport", path, "", res.getError());
				}
				return success("MASSFATransactionReport", ValidationType.CARDINALITY, "MASSFATransactionReport", path, "");
			})
			.collect(toList());
	}

}
