package drr.standards.iosco.cde.datetime.reports;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.DateRange;
import cdm.base.datetime.PeriodicDates;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.ObservationDates;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.EconomicTerms;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.AdjustableDateResolution;
import drr.regulation.common.functions.AdjustableDatesResolution;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsCommoditySwaption;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExpirationDateRule.ExpirationDateRuleDefault.class)
public abstract class ExpirationDateRule implements ReportFunction<Product, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustableDateResolution adjustableDateResolution;
	@Inject protected AdjustableDatesResolution adjustableDatesResolution;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(Product input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(Product input);

	public static class ExpirationDateRuleDefault extends ExpirationDateRule {
		@Override
		protected Date doEvaluate(Product input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, Product input) {
			output = MapperS.of(input)
				.mapSingleToItem(product -> {
					final MapperS<EconomicTerms> thenArg0 = MapperS.of(economicTermsForProduct.evaluate(product.get()));
					final MapperS<Date> ifThenElseResult;
					if (exists(thenArg0.<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						ifThenElseResult = MapperS.of(adjustableDateResolution.evaluate(thenArg0.<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()));
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg1 = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						ifThenElseResult = thenArg1
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg2 = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						ifThenElseResult = thenArg2
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())).getOrDefault(false)) {
						final MapperListOfLists<Date> thenArg3 = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())
							.mapItemToList(item -> MapperC.<Date>of(adjustableDatesResolution.evaluate(item.get())));
						final MapperC<Date> thenArg4 = thenArg3
							.flattenList();
						ifThenElseResult = thenArg4
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg5 = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						ifThenElseResult = thenArg5
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())).getOrDefault(false)) {
						ifThenElseResult = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())).getOrDefault(false)) {
						ifThenElseResult = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max();
					} else if (exists(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<ObservationTerms>map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).<ObservationDates>map("getObservationDates", observationTerms -> observationTerms.getObservationDates()).<PeriodicDates>map("getPeriodicSchedule", observationDates -> observationDates.getPeriodicSchedule()).<AdjustableOrRelativeDate>map("getEndDate", periodicDates -> periodicDates.getEndDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg6 = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<ObservationTerms>map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).<ObservationDates>map("getObservationDates", observationTerms -> observationTerms.getObservationDates()).<PeriodicDates>map("getPeriodicSchedule", observationDates -> observationDates.getPeriodicSchedule()).<AdjustableOrRelativeDate>map("getEndDate", periodicDates -> periodicDates.getEndDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						ifThenElseResult = thenArg6
							.max();
					} else if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product.get()))).or(ComparisonResult.of(MapperS.of(isCommodityFloatingPriceForward.evaluate(product.get())))).getOrDefault(false)) {
						ifThenElseResult = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
							.max();
					} else {
						final Boolean _boolean = isCommodityFixedPriceForward.evaluate(product.get());
						if ((_boolean == null ? false : _boolean)) {
							ifThenElseResult = thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
								.max();
						} else if (ComparisonResult.of(MapperS.of(isCommodityOption.evaluate(product.get()))).or(ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product.get())))).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(thenArg0.<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
								.max();
						} else {
							ifThenElseResult = MapperS.<Date>ofNull();
						}
					}
					return ifThenElseResult;
				}).get();
			
			return output;
		}
	}
}
