package drr.standards.iosco.cde.functions;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.SettlementTermsLeg1;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.Leg.LegBuilder;
import drr.standards.iosco.cde.payment.reports.PeriodicPaymentRule;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.price.reports.InterestRateFixedRateRule;
import drr.standards.iosco.cde.price.reports.SpreadLeg1CurrencyRule;
import drr.standards.iosco.cde.price.reports.SpreadLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.TotalNotionalQuantityLeg1Rule;
import drr.standards.iosco.cde.settlement.reports.SettlementCurrencyRule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg1.Leg1Default.class)
public abstract class Leg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateFixedRateRule interestRateFixedRateRule;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected NotionalAmountLeg1Rule notionalAmountLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected SettlementCurrencyRule settlementCurrencyRule;
	@Inject protected SettlementTermsLeg1 settlementTermsLeg1;
	@Inject protected SpreadLeg1CurrencyRule spreadLeg1CurrencyRule;
	@Inject protected SpreadLeg1Rule spreadLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;

	/**
	* @param transaction 
	* @param spreadNotation 
	* @return leg 
	*/
	public Leg evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation) {
		Leg.LegBuilder legBuilder = doEvaluate(transaction, spreadNotation);
		
		final Leg leg;
		if (legBuilder == null) {
			leg = null;
		} else {
			leg = legBuilder.build();
			objectValidator.validate(Leg.class, leg);
		}
		
		return leg;
	}

	protected abstract Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation);

	public static class Leg1Default extends Leg1 {
		@Override
		protected Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation) {
			Leg.LegBuilder leg = Leg.builder();
			return assignOutput(leg, transaction, spreadNotation);
		}
		
		protected Leg.LegBuilder assignOutput(Leg.LegBuilder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation) {
			leg = toBuilder(MapperS.of(transaction)
				.mapSingleToItem(item -> {
					final MapperS<Product> thenArg0 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<Product> thenArg1 = thenArg0
						.mapSingleToItem(_item -> MapperS.of(productOrUnderlierProduct.evaluate(_item.get())));
					final MapperS<Product> thenArg2 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<SettlementTerms> thenArg3 = thenArg2
						.mapSingleToItem(_item -> MapperS.of(settlementTermsLeg1.evaluate(_item.get())));
					return MapperS.of(Leg.builder()
						.setPeriodicPayment(periodicPaymentRule.evaluate(interestRateLeg1.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(item.get())))))
						.setFixedRate(MapperS.of(interestRateFixedRateRule.evaluate(interestRateLeg1.evaluate(thenArg1.get()))).get())
						.setNotionalAmount(notionalAmountLeg1Rule.evaluate(item.get()))
						.setNotionalCurrency(notionalCurrencyLeg1Rule.evaluate(item.get()))
						.setTotalNotionalQuantity(totalNotionalQuantityLeg1Rule.evaluate(item.get()))
						.setNotionalAmountSchedule(new ArrayList(notionalAmountScheduleLeg1Rule.evaluate(item.get())))
						.setNotionalQuantitySchedule(new ArrayList(notionalQuantityScheduleLeg1Rule.evaluate(item.get())))
						.setSettlementCurrency(thenArg3
							.mapSingleToItem(_item -> MapperS.of(settlementCurrencyRule.evaluate(_item.get()))).get())
						.setSpread(item
							.mapSingleToItem(_item -> MapperS.of(priceFormatFromNotation.evaluate(MapperS.of(spreadLeg1Rule.evaluate(_item.get())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), spreadNotation))).get())
						.setSpreadNotation(spreadNotation)
						.setSpreadCurrency(item
							.mapSingleToItem(_item -> MapperS.of(spreadLeg1CurrencyRule.evaluate(_item.get()))).get())
						.build());
				}).get());
			
			return Optional.ofNullable(leg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
