package drr.standards.iosco.cde.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(GetReportableStrikePricePeriod.GetReportableStrikePricePeriodDefault.class)
public abstract class GetReportableStrikePricePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetReportableSchedulePeriod getReportableSchedulePeriod;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @param notation 
	* @return reportablePeriod 
	*/
	public List<? extends PricePeriod> evaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
		List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = doEvaluate(reportableEvent, notation);
		
		final List<? extends PricePeriod> reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PricePeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation);

	protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation);

	protected abstract MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation);

	public static class GetReportableStrikePricePeriodDefault extends GetReportableStrikePricePeriod {
		@Override
		protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			List<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<>();
			return assignOutput(reportablePeriod, reportableEvent, notation);
		}
		
		protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent, PriceNotationEnum notation) {
			reportablePeriod.addAll(toBuilder(getReportableSchedulePeriod.evaluate(strikePriceSchedule(reportableEvent, notation).get(), customizedSchedule(reportableEvent, notation).get(), notation)));
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			if (ComparisonResult.of(MapperS.of(isCommodityOption.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))))))).getOrDefault(false)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()).get());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends PriceSchedule> strikePriceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			return MapperS.of(MapperC.of(contract_StrikePrice.evaluate(reportableEvent)).get());
		}
	}
}
