package drr.standards.iosco.cde.price.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.Observable;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PriceOfZeroCouponSwaps.PriceOfZeroCouponSwapsDefault.class)
public abstract class PriceOfZeroCouponSwaps implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param reportableEvent 
	* @return knownAmountPrice 
	*/
	public List<? extends NonNegativeQuantitySchedule> evaluate(ReportableEvent reportableEvent) {
		List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPriceBuilder = doEvaluate(reportableEvent);
		
		final List<? extends NonNegativeQuantitySchedule> knownAmountPrice;
		if (knownAmountPriceBuilder == null) {
			knownAmountPrice = null;
		} else {
			knownAmountPrice = knownAmountPriceBuilder.stream().map(NonNegativeQuantitySchedule::build).collect(Collectors.toList());
			objectValidator.validate(NonNegativeQuantitySchedule.class, knownAmountPrice);
		}
		
		return knownAmountPrice;
	}

	protected abstract List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> doEvaluate(ReportableEvent reportableEvent);

	public static class PriceOfZeroCouponSwapsDefault extends PriceOfZeroCouponSwaps {
		@Override
		protected List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> doEvaluate(ReportableEvent reportableEvent) {
			List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPrice = new ArrayList<>();
			return assignOutput(knownAmountPrice, reportableEvent);
		}
		
		protected List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> assignOutput(List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPrice, ReportableEvent reportableEvent) {
			final MapperC<PriceQuantity> thenArg0 = MapperS.of(tradableProductForEvent.evaluate(reportableEvent))
				.mapSingleToList(item -> item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()));
			final MapperC<PriceQuantity> thenArg1 = thenArg0
				.filterItemNullSafe(item -> notExists(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
			final MapperListOfLists<FieldWithMetaNonNegativeQuantitySchedule> thenArg2 = thenArg1
				.mapItemToList(item -> item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
			final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg3 = thenArg2
				.flattenList();
			knownAmountPrice.addAll(toBuilder(MapperS.of(thenArg3.get()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti()));
			
			return Optional.ofNullable(knownAmountPrice)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
