package drr.standards.iosco.cde.price.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.functions.Contract_Price_Monetary;
import drr.standards.iosco.cde.price.functions.PriceOfZeroCouponSwaps;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PriceNotationRule.PriceNotationRuleDefault.class)
public abstract class PriceNotationRule implements ReportFunction<ReportableEvent, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price_Monetary contract_Price_Monetary;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(ReportableEvent input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(ReportableEvent input);

	public static class PriceNotationRuleDefault extends PriceNotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(ReportableEvent input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, ReportableEvent input) {
			final Boolean _boolean = isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForEvent.evaluate(input));
			if ((_boolean == null ? false : _boolean)) {
				final MapperC<NonNegativeQuantitySchedule> thenArg = MapperC.<NonNegativeQuantitySchedule>of(priceOfZeroCouponSwaps.evaluate(input));
				final MapperS<PriceNotationEnum> ifThenElseResult;
				if (exists(thenArg.<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(false)) {
					ifThenElseResult = MapperS.of(PriceNotationEnum.MONETARY);
				} else {
					ifThenElseResult = MapperS.of(PriceNotationEnum.DECIMAL);
				}
				output = ifThenElseResult.get();
			} else {
				output = MapperS.of(MapperC.of(contract_Price_Monetary.evaluate(input)).get())
					.mapSingleToItem(item -> MapperS.of(getPriceNotation.evaluate(item.get()))).get();
			}
			
			return output;
		}
	}
}
