package drr.standards.iosco.cde.price.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadLeg2CurrencyRule.SpreadLeg2CurrencyRuleDefault.class)
public abstract class SpreadLeg2CurrencyRule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg2CurrencyRuleDefault extends SpreadLeg2CurrencyRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final PriceSchedule priceSchedule = spreadLeg2Rule.evaluate(input);
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg0 = priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
			final MapperS<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = item.get();
					if (areEqual(MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
						return item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).<UnitType>map("getUnit", _priceSchedule -> _priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency());
					}
					return MapperS.<FieldWithMetaString>ofNull();
				});
			output = thenArg1
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
