package drr.standards.iosco.cde.price.reports;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.SpreadSchedule.SpreadScheduleBuilder;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Spread_InterestRateRule.Spread_InterestRateRuleDefault.class)
public abstract class Spread_InterestRateRule implements ReportFunction<InterestRatePayout, SpreadSchedule> {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public SpreadSchedule evaluate(InterestRatePayout input) {
		SpreadSchedule.SpreadScheduleBuilder outputBuilder = doEvaluate(input);
		
		final SpreadSchedule output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(SpreadSchedule.class, output);
		}
		
		return output;
	}

	protected abstract SpreadSchedule.SpreadScheduleBuilder doEvaluate(InterestRatePayout input);

	public static class Spread_InterestRateRuleDefault extends Spread_InterestRateRule {
		@Override
		protected SpreadSchedule.SpreadScheduleBuilder doEvaluate(InterestRatePayout input) {
			SpreadSchedule.SpreadScheduleBuilder output = SpreadSchedule.builder();
			return assignOutput(output, input);
		}
		
		protected SpreadSchedule.SpreadScheduleBuilder assignOutput(SpreadSchedule.SpreadScheduleBuilder output, InterestRatePayout input) {
			output = toBuilder(MapperS.of(input).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<SpreadSchedule>map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
