package drr.standards.iosco.cde.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.functions.Contract_StrikePrice;
import javax.inject.Inject;


@ImplementedBy(StrikePriceNotationEnumRule.StrikePriceNotationEnumRuleDefault.class)
public abstract class StrikePriceNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;
	@Inject protected GetPriceNotation getPriceNotation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceNotationEnumRuleDefault extends StrikePriceNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(MapperC.of(contract_StrikePrice.evaluate(input)).get())
				.mapSingleToItem(item -> MapperS.of(getPriceNotation.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
