package drr.standards.iosco.cde.quantity;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.quantity.NotionalPeriod;
import drr.standards.iosco.cde.quantity.NotionalPeriod.NotionalPeriodBuilder;
import drr.standards.iosco.cde.quantity.NotionalPeriod.NotionalPeriodBuilderImpl;
import drr.standards.iosco.cde.quantity.NotionalPeriod.NotionalPeriodImpl;
import drr.standards.iosco.cde.quantity.meta.NotionalPeriodMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="NotionalPeriod", builder=NotionalPeriod.NotionalPeriodBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="NotionalPeriod", model="drr", builder=NotionalPeriod.NotionalPeriodBuilderImpl.class, version="6.0.0-dev.128")
public interface NotionalPeriod extends RosettaModelObject {

	NotionalPeriodMeta metaData = new NotionalPeriodMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getValue();
	Date getEffectiveDate();
	Date getEndDate();

	/*********************** Build Methods  ***********************/
	NotionalPeriod build();
	
	NotionalPeriod.NotionalPeriodBuilder toBuilder();
	
	static NotionalPeriod.NotionalPeriodBuilder builder() {
		return new NotionalPeriod.NotionalPeriodBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends NotionalPeriod> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends NotionalPeriod> getType() {
		return NotionalPeriod.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("value"), BigDecimal.class, getValue(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface NotionalPeriodBuilder extends NotionalPeriod, RosettaModelObjectBuilder {
		NotionalPeriod.NotionalPeriodBuilder setValue(BigDecimal value);
		NotionalPeriod.NotionalPeriodBuilder setEffectiveDate(Date effectiveDate);
		NotionalPeriod.NotionalPeriodBuilder setEndDate(Date endDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("value"), BigDecimal.class, getValue(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
		}
		

		NotionalPeriod.NotionalPeriodBuilder prune();
	}

	/*********************** Immutable Implementation of NotionalPeriod  ***********************/
	class NotionalPeriodImpl implements NotionalPeriod {
		private final BigDecimal value;
		private final Date effectiveDate;
		private final Date endDate;
		
		protected NotionalPeriodImpl(NotionalPeriod.NotionalPeriodBuilder builder) {
			this.value = builder.getValue();
			this.effectiveDate = builder.getEffectiveDate();
			this.endDate = builder.getEndDate();
		}
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("value")
		public BigDecimal getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		public NotionalPeriod build() {
			return this;
		}
		
		@Override
		public NotionalPeriod.NotionalPeriodBuilder toBuilder() {
			NotionalPeriod.NotionalPeriodBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(NotionalPeriod.NotionalPeriodBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getEndDate()).ifPresent(builder::setEndDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalPeriod _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalPeriod {" +
				"value=" + this.value + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate +
			'}';
		}
	}

	/*********************** Builder Implementation of NotionalPeriod  ***********************/
	class NotionalPeriodBuilderImpl implements NotionalPeriod.NotionalPeriodBuilder {
	
		protected BigDecimal value;
		protected Date effectiveDate;
		protected Date endDate;
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("value")
		public BigDecimal getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("value")
		public NotionalPeriod.NotionalPeriodBuilder setValue(BigDecimal _value) {
			this.value = _value == null ? null : _value;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public NotionalPeriod.NotionalPeriodBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public NotionalPeriod.NotionalPeriodBuilder setEndDate(Date _endDate) {
			this.endDate = _endDate == null ? null : _endDate;
			return this;
		}
		
		@Override
		public NotionalPeriod build() {
			return new NotionalPeriod.NotionalPeriodImpl(this);
		}
		
		@Override
		public NotionalPeriod.NotionalPeriodBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalPeriod.NotionalPeriodBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getEndDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalPeriod.NotionalPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			NotionalPeriod.NotionalPeriodBuilder o = (NotionalPeriod.NotionalPeriodBuilder) other;
			
			
			merger.mergeBasic(getValue(), o.getValue(), this::setValue);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getEndDate(), o.getEndDate(), this::setEndDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalPeriod _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalPeriodBuilder {" +
				"value=" + this.value + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate +
			'}';
		}
	}
}
