package drr.standards.iosco.cde.quantity.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(EquityForwardNotional.EquityForwardNotionalDefault.class)
public abstract class EquityForwardNotional implements RosettaFunction {

	/**
	* @param forwardPayout 
	* @return amount 
	*/
	public BigDecimal evaluate(List<? extends ForwardPayout> forwardPayout) {
		BigDecimal amount = doEvaluate(forwardPayout);
		
		return amount;
	}

	protected abstract BigDecimal doEvaluate(List<? extends ForwardPayout> forwardPayout);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends ForwardPayout> forwardPayout);

	protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends ForwardPayout> forwardPayout);

	public static class EquityForwardNotionalDefault extends EquityForwardNotional {
		@Override
		protected BigDecimal doEvaluate(List<? extends ForwardPayout> forwardPayout) {
			if (forwardPayout == null) {
				forwardPayout = Collections.emptyList();
			}
			BigDecimal amount = null;
			return assignOutput(amount, forwardPayout);
		}
		
		protected BigDecimal assignOutput(BigDecimal amount, List<? extends ForwardPayout> forwardPayout) {
			if (exists(quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(false)) {
				amount = multipliedQuantity(forwardPayout).get();
			} else if (exists(quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
				final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = MapperC.<ForwardPayout>of(forwardPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).<ReferenceWithMetaPriceSchedule>mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
				amount = MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(multipliedQuantity(forwardPayout), (referenceWithMetaPriceSchedule == null ? MapperS.<PriceSchedule>ofNull() : MapperS.of(referenceWithMetaPriceSchedule.getValue())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue())).get();
			} else {
				amount = null;
			}
			
			return amount;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends ForwardPayout> forwardPayout) {
			return MapperS.of(MapperC.of(forwardPayout).get()).<ResolvablePriceQuantity>map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
		}
		
		@Override
		protected MapperS<BigDecimal> multipliedQuantity(List<? extends ForwardPayout> forwardPayout) {
			if (exists(quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(false)) {
				return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).<BigDecimal>map("getValue", measure -> measure.getValue()));
			}
			return quantity(forwardPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
		}
	}
}
