package drr.standards.iosco.cde.quantity.functions;

import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceNotional.PerformanceNotionalDefault.class)
public abstract class PerformanceNotional implements RosettaFunction {

	/**
	* @param performancePayout 
	* @return amount 
	*/
	public BigDecimal evaluate(List<? extends PerformancePayout> performancePayout) {
		BigDecimal amount = doEvaluate(performancePayout);
		
		return amount;
	}

	protected abstract BigDecimal doEvaluate(List<? extends PerformancePayout> performancePayout);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends PerformancePayout> performancePayout);

	protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends PerformancePayout> performancePayout);

	public static class PerformanceNotionalDefault extends PerformanceNotional {
		@Override
		protected BigDecimal doEvaluate(List<? extends PerformancePayout> performancePayout) {
			if (performancePayout == null) {
				performancePayout = Collections.emptyList();
			}
			BigDecimal amount = null;
			return assignOutput(amount, performancePayout);
		}
		
		protected BigDecimal assignOutput(BigDecimal amount, List<? extends PerformancePayout> performancePayout) {
			if (exists(quantity(performancePayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(false)) {
				amount = multipliedQuantity(performancePayout).get();
			} else {
				amount = null;
			}
			
			return amount;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends PerformancePayout> performancePayout) {
			return MapperS.of(MapperC.of(performancePayout).get()).<ResolvablePriceQuantity>map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
		}
		
		@Override
		protected MapperS<BigDecimal> multipliedQuantity(List<? extends PerformancePayout> performancePayout) {
			if (exists(quantity(performancePayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(false)) {
				return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(quantity(performancePayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), quantity(performancePayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).<BigDecimal>map("getValue", measure -> measure.getValue()));
			}
			return quantity(performancePayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
		}
	}
}
