package drr.standards.iosco.cde.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PerformanceNotionalCurrency.PerformanceNotionalCurrencyDefault.class)
public abstract class PerformanceNotionalCurrency implements RosettaFunction {

	/**
	* @param performancePayout 
	* @return currency 
	*/
	public String evaluate(List<? extends PerformancePayout> performancePayout) {
		String currency = doEvaluate(performancePayout);
		
		return currency;
	}

	protected abstract String doEvaluate(List<? extends PerformancePayout> performancePayout);

	public static class PerformanceNotionalCurrencyDefault extends PerformanceNotionalCurrency {
		@Override
		protected String doEvaluate(List<? extends PerformancePayout> performancePayout) {
			if (performancePayout == null) {
				performancePayout = Collections.emptyList();
			}
			String currency = null;
			return assignOutput(currency, performancePayout);
		}
		
		protected String assignOutput(String currency, List<? extends PerformancePayout> performancePayout) {
			if (areEqual(MapperS.of(MapperC.<PerformancePayout>of(performancePayout).resultCount()), MapperS.of(1), CardinalityOperator.All).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString = MapperS.of(MapperC.of(performancePayout).get()).<ResolvablePriceQuantity>map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				if (fieldWithMetaString == null) {
					currency = null;
				} else {
					currency = fieldWithMetaString.getValue();
				}
			} else {
				currency = null;
			}
			
			return currency;
		}
	}
}
