package drr.standards.iosco.cde.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.ForeignExchange;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.metafields.ReferenceWithMetaResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwaption;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.UnderlierForProduct;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PutQuantity.PutQuantityDefault.class)
public abstract class PutQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCallOption isCallOption;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFloor isFloor;
	@Inject protected IsPutOption isPutOption;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_CreditDefaultSwaption qualify_CreditDefaultSwaption;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return quantitySchedule 
	*/
	public NonNegativeQuantitySchedule evaluate(Product product) {
		NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityScheduleBuilder = doEvaluate(product);
		
		final NonNegativeQuantitySchedule quantitySchedule;
		if (quantityScheduleBuilder == null) {
			quantitySchedule = null;
		} else {
			quantitySchedule = quantityScheduleBuilder.build();
			objectValidator.validate(NonNegativeQuantitySchedule.class, quantitySchedule);
		}
		
		return quantitySchedule;
	}

	protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product product);

	protected abstract MapperS<? extends OptionPayout> optionPayout(Product product);

	protected abstract MapperS<? extends ResolvablePriceQuantity> resolvablePriceQuantity(Product product);

	public static class PutQuantityDefault extends PutQuantity {
		@Override
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product product) {
			NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule = NonNegativeQuantitySchedule.builder();
			return assignOutput(quantitySchedule, product);
		}
		
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule, Product product) {
			if (exists(resolvablePriceQuantity(product).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule())).and(greaterThanEquals(resolvablePriceQuantity(product).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All)).getOrDefault(false)) {
				final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1 = resolvablePriceQuantity(product).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).get();
				if (referenceWithMetaNonNegativeQuantitySchedule1 == null) {
					quantitySchedule = null;
				} else {
					quantitySchedule = toBuilder(referenceWithMetaNonNegativeQuantitySchedule1.getValue());
				}
			} else if (exists(resolvablePriceQuantity(product).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference())).and(greaterThanEquals(resolvablePriceQuantity(product).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference()).<ResolvablePriceQuantity>map("Type coercion", referenceWithMetaResolvablePriceQuantity0 -> referenceWithMetaResolvablePriceQuantity0 == null ? null : referenceWithMetaResolvablePriceQuantity0.getValue()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All)).getOrDefault(false)) {
				final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule3 = resolvablePriceQuantity(product).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference()).<ResolvablePriceQuantity>map("Type coercion", referenceWithMetaResolvablePriceQuantity1 -> referenceWithMetaResolvablePriceQuantity1 == null ? null : referenceWithMetaResolvablePriceQuantity1.getValue()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).get();
				if (referenceWithMetaNonNegativeQuantitySchedule3 == null) {
					quantitySchedule = null;
				} else {
					quantitySchedule = toBuilder(referenceWithMetaNonNegativeQuantitySchedule3.getValue());
				}
			} else {
				quantitySchedule = null;
			}
			
			return Optional.ofNullable(quantitySchedule)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends OptionPayout> optionPayout(Product product) {
			return MapperS.of(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get());
		}
		
		@Override
		protected MapperS<? extends ResolvablePriceQuantity> resolvablePriceQuantity(Product product) {
			final Boolean boolean0 = isFXOption.evaluate(product);
			if ((boolean0 == null ? false : boolean0)) {
				if (areEqual(optionPayout(product).<BuyerSeller>map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), optionPayout(product).<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), CardinalityOperator.All).getOrDefault(false)) {
					return optionPayout(product).<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity());
				}
				return optionPayout(product).<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity());
			}
			if (ComparisonResult.of(MapperS.of(isPutOption.evaluate(product))).and(areEqual(MapperS.of(qualify_CreditDefaultSwaption.evaluate(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
				return MapperS.of(underlierForProduct.evaluate(product))
					.mapSingleToItem(item -> item.<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<ResolvablePriceQuantity>map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()));
			}
			if (ComparisonResult.of(MapperS.of(isCallOption.evaluate(product))).and(areEqual(MapperS.of(qualify_CreditDefaultSwaption.evaluate(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
				final MapperC<ResolvablePriceQuantity> thenArg0 = MapperS.of(underlierForProduct.evaluate(product))
					.mapSingleToList(item -> item.<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()));
				return MapperS.of(thenArg0.get());
			}
			if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				final MapperC<InterestRatePayout> thenArg1 = optionPayout(product).<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
					.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
				final MapperC<InterestRatePayout> thenArg2 = thenArg1
					.filterItemNullSafe(item -> areEqual(item.<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer()), optionPayout(product).<BuyerSeller>map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), CardinalityOperator.All).get());
				final MapperS<InterestRatePayout> thenArg3 = MapperS.of(thenArg2.get());
				return thenArg3
					.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()));
			}
			final Boolean boolean1 = isFloor.evaluate(product);
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
			}
			if (ComparisonResult.of(MapperS.of(isPutOption.evaluate(product))).and(areEqual(MapperS.of(qualify_Commodity_Swaption.evaluate(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
				return MapperS.of(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity());
			}
			return MapperS.<ResolvablePriceQuantity>ofNull();
		}
	}
}
