package drr.standards.iosco.cde.quantity.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;


@ImplementedBy(CreditNotionalCurrencyRule.CreditNotionalCurrencyRuleDefault.class)
public abstract class CreditNotionalCurrencyRule implements ReportFunction<CreditDefaultPayout, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CreditDefaultPayout input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CreditDefaultPayout input);

	public static class CreditNotionalCurrencyRuleDefault extends CreditNotionalCurrencyRule {
		@Override
		protected String doEvaluate(CreditDefaultPayout input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CreditDefaultPayout input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input).<ResolvablePriceQuantity>map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
