package drr.standards.iosco.cde.quantity.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ForwardNotionalCurrencyRule.ForwardNotionalCurrencyRuleDefault.class)
public abstract class ForwardNotionalCurrencyRule implements ReportFunction<ForwardPayout, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ForwardPayout input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ForwardPayout input);

	public static class ForwardNotionalCurrencyRuleDefault extends ForwardNotionalCurrencyRule {
		@Override
		protected String doEvaluate(ForwardPayout input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ForwardPayout input) {
			if (exists(MapperS.of(input).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString = MapperS.of(input).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				if (fieldWithMetaString == null) {
					output = null;
				} else {
					output = fieldWithMetaString.getValue();
				}
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
