package drr.standards.iosco.cde.quantity.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.PayoutLeg1;
import drr.regulation.common.functions.TradableProductForEvent;
import drr.standards.iosco.cde.quantity.functions.NotionalLeg;
import javax.inject.Inject;


@ImplementedBy(NotionalCurrencyLeg1Rule.NotionalCurrencyLeg1RuleDefault.class)
public abstract class NotionalCurrencyLeg1Rule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected NotionalLeg notionalLeg;
	@Inject protected PayoutLeg1 payoutLeg1;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class NotionalCurrencyLeg1RuleDefault extends NotionalCurrencyLeg1Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final MapperS<FieldWithMetaString> thenArg = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(input);
					final MapperS<TradableProduct> thenArg0;
					if ((_boolean == null ? false : _boolean)) {
						thenArg0 = MapperS.of(beforeTradeForEvent.evaluate(input)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
					} else {
						thenArg0 = MapperS.of(tradableProductForEvent.evaluate(input));
					}
					final MapperS<PayoutLegWithAuxiliary> thenArg1 = thenArg0
						.mapSingleToItem(item -> MapperS.of(payoutLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
					return thenArg1
						.mapSingleToItem(item -> MapperS.of(notionalLeg.evaluate(item.get())).<UnitType>map("getUnit", measure -> measure.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
				});
			output = thenArg
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
