package drr.standards.iosco.cde.quantity.reports;

import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsCommodity;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;


@ImplementedBy(TotalNotionalQuantityLeg1Rule.TotalNotionalQuantityLeg1RuleDefault.class)
public abstract class TotalNotionalQuantityLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected CommodityTotalNotionalQuantityRule commodityTotalNotionalQuantityRule;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected EquityTotalNotionalQuantityRule equityTotalNotionalQuantityRule;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FixedPriceTotalNotionalQuantityRule fixedPriceTotalNotionalQuantityRule;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsCommodity isCommodity;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsEquity isEquity;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected OptionTotalNotionalQuantityRule optionTotalNotionalQuantityRule;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class TotalNotionalQuantityLeg1RuleDefault extends TotalNotionalQuantityLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Trade> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(isEquity.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isCommodity.evaluate(productForTrade.evaluate(item.get()))))).get());
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isEquity.evaluate(productForTrade.evaluate(item.get()));
					final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
					final MapperS<BigDecimal> ifThenElseResult;
					if ((boolean0 == null ? false : boolean0)) {
						ifThenElseResult = MapperS.of(equityTotalNotionalQuantityRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).get()));
					} else {
						final Boolean boolean1 = isCommoditySwapFloatFloat.evaluate(productForTrade.evaluate(item.get()));
						if ((boolean1 == null ? false : boolean1)) {
							ifThenElseResult = MapperS.of(commodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(productForTrade.evaluate(item.get()))));
						} else if (ComparisonResult.of(MapperS.of(isSingleCommodityPayoutProduct.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isCommodityFloatingPriceForward.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
							ifThenElseResult = MapperS.of(commodityTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()));
						} else {
							final Boolean boolean2 = isCommoditySwapFixedFloat.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean2 == null ? false : boolean2)) {
								ifThenElseResult = MapperS.of(fixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(productForTrade.evaluate(item.get()))));
							} else {
								final Boolean boolean3 = isCommodityFixedPriceForward.evaluate(productForTrade.evaluate(item.get()));
								if ((boolean3 == null ? false : boolean3)) {
									ifThenElseResult = MapperS.of(fixedPriceTotalNotionalQuantityRule.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()));
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
									ifThenElseResult = MapperS.of(commodityTotalNotionalQuantityRule.evaluate(commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
									ifThenElseResult = MapperS.of(fixedPriceTotalNotionalQuantityRule.evaluate(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
								} else {
									final Boolean boolean4 = qualify_Commodity_Option.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
									if ((boolean4 == null ? false : boolean4)) {
										ifThenElseResult = MapperS.of(optionTotalNotionalQuantityRule.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
									} else {
										ifThenElseResult = MapperS.<BigDecimal>ofNull();
									}
								}
							}
						}
					}
					return MapperS.of(ifThenElseResult.getOrDefault((bigInteger == null ? null : new BigDecimal(bigInteger))));
				});
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
