package drr.standards.iosco.cde.underlier.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CryptoAssetUnderlyingIndicatorRule.CryptoAssetUnderlyingIndicatorRuleDefault.class)
public abstract class CryptoAssetUnderlyingIndicatorRule implements ReportFunction<ReportableEvent, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(ReportableEvent input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(ReportableEvent input);

	public static class CryptoAssetUnderlyingIndicatorRuleDefault extends CryptoAssetUnderlyingIndicatorRule {
		@Override
		protected Boolean doEvaluate(ReportableEvent input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, ReportableEvent input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (exists(item.<ReportableInformation>map("getReportableInformation", reportableEvent -> reportableEvent.getReportableInformation()).<Boolean>map("getCryptoBased", reportableInformation -> reportableInformation.getCryptoBased())).getOrDefault(false)) {
						return item.<ReportableInformation>map("getReportableInformation", reportableEvent -> reportableEvent.getReportableInformation()).<Boolean>map("getCryptoBased", reportableInformation -> reportableInformation.getCryptoBased());
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
