package drr.standards.iosco.cde.underlier.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;


@ImplementedBy(UnderlyingAssetPriceSourceRule.UnderlyingAssetPriceSourceRuleDefault.class)
public abstract class UnderlyingAssetPriceSourceRule implements ReportFunction<ReportableEvent, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class UnderlyingAssetPriceSourceRuleDefault extends UnderlyingAssetPriceSourceRule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of("Not modelled")).get();
			
			return output;
		}
	}
}
