package drr.standards.iosco.cde.underlier.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;


@ImplementedBy(UnderlyingAssetTradingPlatformIdentifierRule.UnderlyingAssetTradingPlatformIdentifierRuleDefault.class)
public abstract class UnderlyingAssetTradingPlatformIdentifierRule implements ReportFunction<ReportableEvent, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(ReportableEvent input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(ReportableEvent input);

	public static class UnderlyingAssetTradingPlatformIdentifierRuleDefault extends UnderlyingAssetTradingPlatformIdentifierRule {
		@Override
		protected Void doEvaluate(ReportableEvent input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, ReportableEvent input) {
			output = null;
			
			return output;
		}
	}
}
