package drr.standards.iosco.cde.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.PeriodicPayment;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class LegValidator implements Validator<Leg> {

	private List<ComparisonResult> getComparisonResults(Leg o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("periodicPayment", (PeriodicPayment) o.getPeriodicPayment() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmount", (BigDecimal) o.getNotionalAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrency", (ISOCurrencyCodeEnum) o.getNotionalCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantity", (BigDecimal) o.getTotalNotionalQuantity() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRate", (BigDecimal) o.getFixedRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency", (ISOCurrencyCodeEnum) o.getSettlementCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("spread", (PriceFormat) o.getSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotation", (PriceNotationEnum) o.getSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrency", (ISOCurrencyCodeEnum) o.getSpreadCurrency() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Leg o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Leg", ValidationType.CARDINALITY, "Leg", path, "", res.getError());
				}
				return success("Leg", ValidationType.CARDINALITY, "Leg", path, "");
			})
			.collect(toList());
	}

}
