package drr.standards.iosco.cde.valuation.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.GetValuation;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ValuationAmountRule.ValuationAmountRuleDefault.class)
public abstract class ValuationAmountRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected GetValuation getValuation;
	@Inject protected RoundToPrecision roundToPrecision;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class ValuationAmountRuleDefault extends ValuationAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<BigDecimal> thenArg0 = MapperS.of(getValuation.evaluate(input)).<Money>map("getAmount", valuation -> valuation.getAmount()).<BigDecimal>map("getValue", money -> money.getValue());
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST)));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
