package iso20022.auth030.asic;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.asic.DerivativesTradeReportV04;
import iso20022.auth030.asic.DerivativesTradeReportV04.DerivativesTradeReportV04Builder;
import iso20022.auth030.asic.DerivativesTradeReportV04.DerivativesTradeReportV04BuilderImpl;
import iso20022.auth030.asic.DerivativesTradeReportV04.DerivativesTradeReportV04Impl;
import iso20022.auth030.asic.TradeData59Choice__1;
import iso20022.auth030.asic.TradeData59Choice__1.TradeData59Choice__1Builder;
import iso20022.auth030.asic.TradeReportHeader4__1;
import iso20022.auth030.asic.TradeReportHeader4__1.TradeReportHeader4__1Builder;
import iso20022.auth030.asic.meta.DerivativesTradeReportV04Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1.22.0
 */
@RosettaDataType(value="DerivativesTradeReportV04", builder=DerivativesTradeReportV04.DerivativesTradeReportV04BuilderImpl.class, version="1.22.0")
@RuneDataType(value="DerivativesTradeReportV04", model="iso20022", builder=DerivativesTradeReportV04.DerivativesTradeReportV04BuilderImpl.class, version="1.22.0")
public interface DerivativesTradeReportV04 extends RosettaModelObject {

	DerivativesTradeReportV04Meta metaData = new DerivativesTradeReportV04Meta();

	/*********************** Getter Methods  ***********************/
	TradeReportHeader4__1 getRptHdr();
	TradeData59Choice__1 getTradData();

	/*********************** Build Methods  ***********************/
	DerivativesTradeReportV04 build();
	
	DerivativesTradeReportV04.DerivativesTradeReportV04Builder toBuilder();
	
	static DerivativesTradeReportV04.DerivativesTradeReportV04Builder builder() {
		return new DerivativesTradeReportV04.DerivativesTradeReportV04BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends DerivativesTradeReportV04> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends DerivativesTradeReportV04> getType() {
		return DerivativesTradeReportV04.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("rptHdr"), processor, TradeReportHeader4__1.class, getRptHdr());
		processRosetta(path.newSubPath("tradData"), processor, TradeData59Choice__1.class, getTradData());
	}
	

	/*********************** Builder Interface  ***********************/
	interface DerivativesTradeReportV04Builder extends DerivativesTradeReportV04, RosettaModelObjectBuilder {
		TradeReportHeader4__1.TradeReportHeader4__1Builder getOrCreateRptHdr();
		@Override
		TradeReportHeader4__1.TradeReportHeader4__1Builder getRptHdr();
		TradeData59Choice__1.TradeData59Choice__1Builder getOrCreateTradData();
		@Override
		TradeData59Choice__1.TradeData59Choice__1Builder getTradData();
		DerivativesTradeReportV04.DerivativesTradeReportV04Builder setRptHdr(TradeReportHeader4__1 rptHdr);
		DerivativesTradeReportV04.DerivativesTradeReportV04Builder setTradData(TradeData59Choice__1 tradData);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("rptHdr"), processor, TradeReportHeader4__1.TradeReportHeader4__1Builder.class, getRptHdr());
			processRosetta(path.newSubPath("tradData"), processor, TradeData59Choice__1.TradeData59Choice__1Builder.class, getTradData());
		}
		

		DerivativesTradeReportV04.DerivativesTradeReportV04Builder prune();
	}

	/*********************** Immutable Implementation of DerivativesTradeReportV04  ***********************/
	class DerivativesTradeReportV04Impl implements DerivativesTradeReportV04 {
		private final TradeReportHeader4__1 rptHdr;
		private final TradeData59Choice__1 tradData;
		
		protected DerivativesTradeReportV04Impl(DerivativesTradeReportV04.DerivativesTradeReportV04Builder builder) {
			this.rptHdr = ofNullable(builder.getRptHdr()).map(f->f.build()).orElse(null);
			this.tradData = ofNullable(builder.getTradData()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("rptHdr")
		@RuneAttribute("rptHdr")
		public TradeReportHeader4__1 getRptHdr() {
			return rptHdr;
		}
		
		@Override
		@RosettaAttribute("tradData")
		@RuneAttribute("tradData")
		public TradeData59Choice__1 getTradData() {
			return tradData;
		}
		
		@Override
		public DerivativesTradeReportV04 build() {
			return this;
		}
		
		@Override
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder toBuilder() {
			DerivativesTradeReportV04.DerivativesTradeReportV04Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(DerivativesTradeReportV04.DerivativesTradeReportV04Builder builder) {
			ofNullable(getRptHdr()).ifPresent(builder::setRptHdr);
			ofNullable(getTradData()).ifPresent(builder::setTradData);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DerivativesTradeReportV04 _that = getType().cast(o);
		
			if (!Objects.equals(rptHdr, _that.getRptHdr())) return false;
			if (!Objects.equals(tradData, _that.getTradData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (rptHdr != null ? rptHdr.hashCode() : 0);
			_result = 31 * _result + (tradData != null ? tradData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DerivativesTradeReportV04 {" +
				"rptHdr=" + this.rptHdr + ", " +
				"tradData=" + this.tradData +
			'}';
		}
	}

	/*********************** Builder Implementation of DerivativesTradeReportV04  ***********************/
	class DerivativesTradeReportV04BuilderImpl implements DerivativesTradeReportV04.DerivativesTradeReportV04Builder {
	
		protected TradeReportHeader4__1.TradeReportHeader4__1Builder rptHdr;
		protected TradeData59Choice__1.TradeData59Choice__1Builder tradData;
		
		@Override
		@RosettaAttribute("rptHdr")
		@RuneAttribute("rptHdr")
		public TradeReportHeader4__1.TradeReportHeader4__1Builder getRptHdr() {
			return rptHdr;
		}
		
		@Override
		public TradeReportHeader4__1.TradeReportHeader4__1Builder getOrCreateRptHdr() {
			TradeReportHeader4__1.TradeReportHeader4__1Builder result;
			if (rptHdr!=null) {
				result = rptHdr;
			}
			else {
				result = rptHdr = TradeReportHeader4__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("tradData")
		@RuneAttribute("tradData")
		public TradeData59Choice__1.TradeData59Choice__1Builder getTradData() {
			return tradData;
		}
		
		@Override
		public TradeData59Choice__1.TradeData59Choice__1Builder getOrCreateTradData() {
			TradeData59Choice__1.TradeData59Choice__1Builder result;
			if (tradData!=null) {
				result = tradData;
			}
			else {
				result = tradData = TradeData59Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("rptHdr")
		@RuneAttribute("rptHdr")
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder setRptHdr(TradeReportHeader4__1 _rptHdr) {
			this.rptHdr = _rptHdr == null ? null : _rptHdr.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("tradData")
		@RuneAttribute("tradData")
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder setTradData(TradeData59Choice__1 _tradData) {
			this.tradData = _tradData == null ? null : _tradData.toBuilder();
			return this;
		}
		
		@Override
		public DerivativesTradeReportV04 build() {
			return new DerivativesTradeReportV04.DerivativesTradeReportV04Impl(this);
		}
		
		@Override
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder prune() {
			if (rptHdr!=null && !rptHdr.prune().hasData()) rptHdr = null;
			if (tradData!=null && !tradData.prune().hasData()) tradData = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getRptHdr()!=null && getRptHdr().hasData()) return true;
			if (getTradData()!=null && getTradData().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DerivativesTradeReportV04.DerivativesTradeReportV04Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			DerivativesTradeReportV04.DerivativesTradeReportV04Builder o = (DerivativesTradeReportV04.DerivativesTradeReportV04Builder) other;
			
			merger.mergeRosetta(getRptHdr(), o.getRptHdr(), this::setRptHdr);
			merger.mergeRosetta(getTradData(), o.getTradData(), this::setTradData);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DerivativesTradeReportV04 _that = getType().cast(o);
		
			if (!Objects.equals(rptHdr, _that.getRptHdr())) return false;
			if (!Objects.equals(tradData, _that.getTradData())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (rptHdr != null ? rptHdr.hashCode() : 0);
			_result = 31 * _result + (tradData != null ? tradData.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DerivativesTradeReportV04Builder {" +
				"rptHdr=" + this.rptHdr + ", " +
				"tradData=" + this.tradData +
			'}';
		}
	}
}
