package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.FloatingRate13__3;
import iso20022.auth030.asic.InterestRate33Choice__3;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class InterestRate33Choice__3Validator implements Validator<InterestRate33Choice__3> {

	private List<ComparisonResult> getComparisonResults(InterestRate33Choice__3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("fltg", (FloatingRate13__3) o.getFltg() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRate33Choice__3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("InterestRate33Choice__3", ValidationType.CARDINALITY, "InterestRate33Choice__3", path, "", res.getError());
				}
				return success("InterestRate33Choice__3", ValidationType.CARDINALITY, "InterestRate33Choice__3", path, "");
			})
			.collect(toList());
	}

}
