package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.AgriculturalCommodityGrain3;
import iso20022.auth030.esma.AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder;
import iso20022.auth030.esma.AgriculturalCommodityGrain3.AgriculturalCommodityGrain3BuilderImpl;
import iso20022.auth030.esma.AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Impl;
import iso20022.auth030.esma.AssetClassDetailedSubProductType30Code;
import iso20022.auth030.esma.AssetClassProductType1Code;
import iso20022.auth030.esma.AssetClassSubProductType5Code;
import iso20022.auth030.esma.meta.AgriculturalCommodityGrain3Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an agricultural derivative of type grain.
 * @version 1.22.0
 */
@RosettaDataType(value="AgriculturalCommodityGrain3", builder=AgriculturalCommodityGrain3.AgriculturalCommodityGrain3BuilderImpl.class, version="1.22.0")
@RuneDataType(value="AgriculturalCommodityGrain3", model="iso20022", builder=AgriculturalCommodityGrain3.AgriculturalCommodityGrain3BuilderImpl.class, version="1.22.0")
public interface AgriculturalCommodityGrain3 extends RosettaModelObject {

	AgriculturalCommodityGrain3Meta metaData = new AgriculturalCommodityGrain3Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType1Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType5Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType30Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	AgriculturalCommodityGrain3 build();
	
	AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder toBuilder();
	
	static AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder builder() {
		return new AgriculturalCommodityGrain3.AgriculturalCommodityGrain3BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AgriculturalCommodityGrain3> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AgriculturalCommodityGrain3> getType() {
		return AgriculturalCommodityGrain3.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType5Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType30Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AgriculturalCommodityGrain3Builder extends AgriculturalCommodityGrain3, RosettaModelObjectBuilder {
		AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setBasePdct(AssetClassProductType1Code basePdct);
		AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setSubPdct(AssetClassSubProductType5Code subPdct);
		AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setAddtlSubPdct(AssetClassDetailedSubProductType30Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType5Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType30Code.class, getAddtlSubPdct(), this);
		}
		

		AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder prune();
	}

	/*********************** Immutable Implementation of AgriculturalCommodityGrain3  ***********************/
	class AgriculturalCommodityGrain3Impl implements AgriculturalCommodityGrain3 {
		private final AssetClassProductType1Code basePdct;
		private final AssetClassSubProductType5Code subPdct;
		private final AssetClassDetailedSubProductType30Code addtlSubPdct;
		
		protected AgriculturalCommodityGrain3Impl(AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType5Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType30Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public AgriculturalCommodityGrain3 build() {
			return this;
		}
		
		@Override
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder toBuilder() {
			AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityGrain3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityGrain3 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of AgriculturalCommodityGrain3  ***********************/
	class AgriculturalCommodityGrain3BuilderImpl implements AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder {
	
		protected AssetClassProductType1Code basePdct;
		protected AssetClassSubProductType5Code subPdct;
		protected AssetClassDetailedSubProductType30Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType5Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType30Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setBasePdct(AssetClassProductType1Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setSubPdct(AssetClassSubProductType5Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		@RuneAttribute("addtlSubPdct")
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder setAddtlSubPdct(AssetClassDetailedSubProductType30Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public AgriculturalCommodityGrain3 build() {
			return new AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Impl(this);
		}
		
		@Override
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder o = (AgriculturalCommodityGrain3.AgriculturalCommodityGrain3Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityGrain3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityGrain3Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
