package iso20022.auth030.esma;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import iso20022.auth030.esma.AssetClassSubProductType39Code;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * Defines the sub-product of type Ammonia.
 * @version 1.22.0
 */
@RosettaEnum("AssetClassSubProductType39Code")
public enum AssetClassSubProductType39Code {

	/**
	 * Commodity of type ammonia.
	 */
	@RosettaEnumValue(value = "AMMO") 
	AMMO("AMMO", null)
;
	private static Map<String, AssetClassSubProductType39Code> values;
	static {
        Map<String, AssetClassSubProductType39Code> map = new ConcurrentHashMap<>();
		for (AssetClassSubProductType39Code instance : AssetClassSubProductType39Code.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	AssetClassSubProductType39Code(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static AssetClassSubProductType39Code fromDisplayName(String name) {
		AssetClassSubProductType39Code value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
