package iso20022.auth030.esma.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.TradeData42__3;
import iso20022.auth030.esma.validation.TradeData42__3TypeFormatValidator;
import iso20022.auth030.esma.validation.TradeData42__3Validator;
import iso20022.auth030.esma.validation.exists.TradeData42__3OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 1.22.0
 */
@RosettaMeta(model=TradeData42__3.class)
public class TradeData42__3Meta implements RosettaMetaData<TradeData42__3> {

	@Override
	public List<Validator<? super TradeData42__3>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super TradeData42__3, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super TradeData42__3> validator(ValidatorFactory factory) {
		return factory.<TradeData42__3>create(TradeData42__3Validator.class);
	}

	@Override
	public Validator<? super TradeData42__3> typeFormatValidator(ValidatorFactory factory) {
		return factory.<TradeData42__3>create(TradeData42__3TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super TradeData42__3> validator() {
		return new TradeData42__3Validator();
	}

	@Deprecated
	@Override
	public Validator<? super TradeData42__3> typeFormatValidator() {
		return new TradeData42__3TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super TradeData42__3, Set<String>> onlyExistsValidator() {
		return new TradeData42__3OnlyExistsValidator();
	}
}
