package iso20022.auth030.fca;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import iso20022.auth030.fca.AssetClassSubProductType31Code;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * Defines the sub-product of type Dry Freight.
 * @version 1.22.0
 */
@RosettaEnum("AssetClassSubProductType31Code")
public enum AssetClassSubProductType31Code {

	/**
	 * Commodity of type dry freight.
	 */
	@RosettaEnumValue(value = "DRYF") 
	DRYF("DRYF", null)
;
	private static Map<String, AssetClassSubProductType31Code> values;
	static {
        Map<String, AssetClassSubProductType31Code> map = new ConcurrentHashMap<>();
		for (AssetClassSubProductType31Code instance : AssetClassSubProductType31Code.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	AssetClassSubProductType31Code(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static AssetClassSubProductType31Code fromDisplayName(String name) {
		AssetClassSubProductType31Code value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
