package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassProductType5Code;
import iso20022.auth030.fca.AssetClassSubProductType43Code;
import iso20022.auth030.fca.FertilizerCommodityUrea2__1;
import iso20022.auth030.fca.FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder;
import iso20022.auth030.fca.FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1BuilderImpl;
import iso20022.auth030.fca.FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Impl;
import iso20022.auth030.fca.meta.FertilizerCommodityUrea2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of a fertilizer derivative of type urea.
 * @version 1.22.0
 */
@RosettaDataType(value="FertilizerCommodityUrea2__1", builder=FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1BuilderImpl.class, version="1.22.0")
@RuneDataType(value="FertilizerCommodityUrea2__1", model="iso20022", builder=FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1BuilderImpl.class, version="1.22.0")
public interface FertilizerCommodityUrea2__1 extends RosettaModelObject {

	FertilizerCommodityUrea2__1Meta metaData = new FertilizerCommodityUrea2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType5Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType43Code getSubPdct();

	/*********************** Build Methods  ***********************/
	FertilizerCommodityUrea2__1 build();
	
	FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder toBuilder();
	
	static FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder builder() {
		return new FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FertilizerCommodityUrea2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends FertilizerCommodityUrea2__1> getType() {
		return FertilizerCommodityUrea2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType43Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FertilizerCommodityUrea2__1Builder extends FertilizerCommodityUrea2__1, RosettaModelObjectBuilder {
		FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder setBasePdct(AssetClassProductType5Code basePdct);
		FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder setSubPdct(AssetClassSubProductType43Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType43Code.class, getSubPdct(), this);
		}
		

		FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder prune();
	}

	/*********************** Immutable Implementation of FertilizerCommodityUrea2__1  ***********************/
	class FertilizerCommodityUrea2__1Impl implements FertilizerCommodityUrea2__1 {
		private final AssetClassProductType5Code basePdct;
		private final AssetClassSubProductType43Code subPdct;
		
		protected FertilizerCommodityUrea2__1Impl(FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType43Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public FertilizerCommodityUrea2__1 build() {
			return this;
		}
		
		@Override
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder toBuilder() {
			FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityUrea2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityUrea2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FertilizerCommodityUrea2__1  ***********************/
	class FertilizerCommodityUrea2__1BuilderImpl implements FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder {
	
		protected AssetClassProductType5Code basePdct;
		protected AssetClassSubProductType43Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType43Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder setBasePdct(AssetClassProductType5Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder setSubPdct(AssetClassSubProductType43Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public FertilizerCommodityUrea2__1 build() {
			return new FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Impl(this);
		}
		
		@Override
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder o = (FertilizerCommodityUrea2__1.FertilizerCommodityUrea2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommodityUrea2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommodityUrea2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
