package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassProductType6Code;
import iso20022.auth030.fca.AssetClassSubProductType34Code;
import iso20022.auth030.fca.IndustrialProductCommodityManufacturing2__1;
import iso20022.auth030.fca.IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder;
import iso20022.auth030.fca.IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1BuilderImpl;
import iso20022.auth030.fca.IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Impl;
import iso20022.auth030.fca.meta.IndustrialProductCommodityManufacturing2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an industrial product derivative of type manufacturing.
 * @version 1.22.0
 */
@RosettaDataType(value="IndustrialProductCommodityManufacturing2__1", builder=IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1BuilderImpl.class, version="1.22.0")
@RuneDataType(value="IndustrialProductCommodityManufacturing2__1", model="iso20022", builder=IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1BuilderImpl.class, version="1.22.0")
public interface IndustrialProductCommodityManufacturing2__1 extends RosettaModelObject {

	IndustrialProductCommodityManufacturing2__1Meta metaData = new IndustrialProductCommodityManufacturing2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType6Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType34Code getSubPdct();

	/*********************** Build Methods  ***********************/
	IndustrialProductCommodityManufacturing2__1 build();
	
	IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder toBuilder();
	
	static IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder builder() {
		return new IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends IndustrialProductCommodityManufacturing2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends IndustrialProductCommodityManufacturing2__1> getType() {
		return IndustrialProductCommodityManufacturing2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType6Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType34Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface IndustrialProductCommodityManufacturing2__1Builder extends IndustrialProductCommodityManufacturing2__1, RosettaModelObjectBuilder {
		IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder setBasePdct(AssetClassProductType6Code basePdct);
		IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder setSubPdct(AssetClassSubProductType34Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType6Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType34Code.class, getSubPdct(), this);
		}
		

		IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder prune();
	}

	/*********************** Immutable Implementation of IndustrialProductCommodityManufacturing2__1  ***********************/
	class IndustrialProductCommodityManufacturing2__1Impl implements IndustrialProductCommodityManufacturing2__1 {
		private final AssetClassProductType6Code basePdct;
		private final AssetClassSubProductType34Code subPdct;
		
		protected IndustrialProductCommodityManufacturing2__1Impl(IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType6Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType34Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public IndustrialProductCommodityManufacturing2__1 build() {
			return this;
		}
		
		@Override
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder toBuilder() {
			IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			IndustrialProductCommodityManufacturing2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "IndustrialProductCommodityManufacturing2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of IndustrialProductCommodityManufacturing2__1  ***********************/
	class IndustrialProductCommodityManufacturing2__1BuilderImpl implements IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder {
	
		protected AssetClassProductType6Code basePdct;
		protected AssetClassSubProductType34Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType6Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType34Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder setBasePdct(AssetClassProductType6Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder setSubPdct(AssetClassSubProductType34Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public IndustrialProductCommodityManufacturing2__1 build() {
			return new IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Impl(this);
		}
		
		@Override
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder o = (IndustrialProductCommodityManufacturing2__1.IndustrialProductCommodityManufacturing2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			IndustrialProductCommodityManufacturing2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "IndustrialProductCommodityManufacturing2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
