package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassProductType9Code;
import iso20022.auth030.fca.AssetClassSubProductType49Code;
import iso20022.auth030.fca.PolypropyleneCommodityOther2__1;
import iso20022.auth030.fca.PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder;
import iso20022.auth030.fca.PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1BuilderImpl;
import iso20022.auth030.fca.PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Impl;
import iso20022.auth030.fca.meta.PolypropyleneCommodityOther2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of a propylene derivative of type recovered paper.
 * @version 1.22.0
 */
@RosettaDataType(value="PolypropyleneCommodityOther2__1", builder=PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1BuilderImpl.class, version="1.22.0")
@RuneDataType(value="PolypropyleneCommodityOther2__1", model="iso20022", builder=PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1BuilderImpl.class, version="1.22.0")
public interface PolypropyleneCommodityOther2__1 extends RosettaModelObject {

	PolypropyleneCommodityOther2__1Meta metaData = new PolypropyleneCommodityOther2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType9Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType49Code getSubPdct();

	/*********************** Build Methods  ***********************/
	PolypropyleneCommodityOther2__1 build();
	
	PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder toBuilder();
	
	static PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder builder() {
		return new PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PolypropyleneCommodityOther2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PolypropyleneCommodityOther2__1> getType() {
		return PolypropyleneCommodityOther2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType9Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PolypropyleneCommodityOther2__1Builder extends PolypropyleneCommodityOther2__1, RosettaModelObjectBuilder {
		PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder setBasePdct(AssetClassProductType9Code basePdct);
		PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType9Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
		}
		

		PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder prune();
	}

	/*********************** Immutable Implementation of PolypropyleneCommodityOther2__1  ***********************/
	class PolypropyleneCommodityOther2__1Impl implements PolypropyleneCommodityOther2__1 {
		private final AssetClassProductType9Code basePdct;
		private final AssetClassSubProductType49Code subPdct;
		
		protected PolypropyleneCommodityOther2__1Impl(PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType9Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public PolypropyleneCommodityOther2__1 build() {
			return this;
		}
		
		@Override
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder toBuilder() {
			PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PolypropyleneCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PolypropyleneCommodityOther2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of PolypropyleneCommodityOther2__1  ***********************/
	class PolypropyleneCommodityOther2__1BuilderImpl implements PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder {
	
		protected AssetClassProductType9Code basePdct;
		protected AssetClassSubProductType49Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType9Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder setBasePdct(AssetClassProductType9Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public PolypropyleneCommodityOther2__1 build() {
			return new PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Impl(this);
		}
		
		@Override
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder o = (PolypropyleneCommodityOther2__1.PolypropyleneCommodityOther2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PolypropyleneCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PolypropyleneCommodityOther2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
