package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.AssetClassCommodity7Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilderImpl;
import iso20022.auth030.hkma.dtcc.AssetClassCommodity7Choice.AssetClassCommodity7ChoiceImpl;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityAgricultural6Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityC10Other1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityEnergy3Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityEnvironmental3Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityFertilizer4Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityFreight4Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityIndex1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityIndustrialProduct2Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityInflation1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityMetal2Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityMultiCommodityExotic1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityOfficialEconomicStatistics1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityOther1;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityOther1.AssetClassCommodityOther1Builder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityPaper5Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityPolypropylene4Choice;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder;
import iso20022.auth030.hkma.dtcc.meta.AssetClassCommodity7ChoiceMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Choice to define commodity specific attributes of a derivative.
 * @version 1.22.0
 */
@RosettaDataType(value="AssetClassCommodity7Choice", builder=AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilderImpl.class, version="1.22.0")
@RuneDataType(value="AssetClassCommodity7Choice", model="iso20022", builder=AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilderImpl.class, version="1.22.0")
public interface AssetClassCommodity7Choice extends RosettaModelObject {

	AssetClassCommodity7ChoiceMeta metaData = new AssetClassCommodity7ChoiceMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Agricultural commodities.
	 */
	AssetClassCommodityAgricultural6Choice getAgrcltrl();
	/**
	 * Energy commodities.
	 */
	AssetClassCommodityEnergy3Choice getNrgy();
	/**
	 * Environmental commodities.
	 */
	AssetClassCommodityEnvironmental3Choice getEnvttl();
	/**
	 * Fertilizer commodities.
	 */
	AssetClassCommodityFertilizer4Choice getFrtlzr();
	/**
	 * Freight commodities.
	 */
	AssetClassCommodityFreight4Choice getFrght();
	/**
	 * Indicates the index type of commodities.
	 */
	AssetClassCommodityIndex1 getIndx();
	/**
	 * Industrial Product commodities.
	 */
	AssetClassCommodityIndustrialProduct2Choice getIndstrlPdct();
	/**
	 * Inflation commodities.
	 */
	AssetClassCommodityInflation1 getInfltn();
	/**
	 * Metal commodities.
	 */
	AssetClassCommodityMetal2Choice getMetl();
	/**
	 * Multi Commodity Exotic
	 */
	AssetClassCommodityMultiCommodityExotic1 getMultiCmmdtyExtc();
	/**
	 * Official Economic Statistics commodities.
	 */
	AssetClassCommodityOfficialEconomicStatistics1 getOffclEcnmcSttstcs();
	/**
	 * Other commodities.
	 */
	AssetClassCommodityOther1 getOthr();
	/**
	 * Other C10 commodities.
	 */
	AssetClassCommodityC10Other1 getOthrC10();
	/**
	 * Paper commodities.
	 */
	AssetClassCommodityPaper5Choice getPpr();
	/**
	 * Polypropylene commodities.
	 */
	AssetClassCommodityPolypropylene4Choice getPlprpln();

	/*********************** Build Methods  ***********************/
	AssetClassCommodity7Choice build();
	
	AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder toBuilder();
	
	static AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder builder() {
		return new AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AssetClassCommodity7Choice> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AssetClassCommodity7Choice> getType() {
		return AssetClassCommodity7Choice.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("agrcltrl"), processor, AssetClassCommodityAgricultural6Choice.class, getAgrcltrl());
		processRosetta(path.newSubPath("nrgy"), processor, AssetClassCommodityEnergy3Choice.class, getNrgy());
		processRosetta(path.newSubPath("envttl"), processor, AssetClassCommodityEnvironmental3Choice.class, getEnvttl());
		processRosetta(path.newSubPath("frtlzr"), processor, AssetClassCommodityFertilizer4Choice.class, getFrtlzr());
		processRosetta(path.newSubPath("frght"), processor, AssetClassCommodityFreight4Choice.class, getFrght());
		processRosetta(path.newSubPath("indx"), processor, AssetClassCommodityIndex1.class, getIndx());
		processRosetta(path.newSubPath("indstrlPdct"), processor, AssetClassCommodityIndustrialProduct2Choice.class, getIndstrlPdct());
		processRosetta(path.newSubPath("infltn"), processor, AssetClassCommodityInflation1.class, getInfltn());
		processRosetta(path.newSubPath("metl"), processor, AssetClassCommodityMetal2Choice.class, getMetl());
		processRosetta(path.newSubPath("multiCmmdtyExtc"), processor, AssetClassCommodityMultiCommodityExotic1.class, getMultiCmmdtyExtc());
		processRosetta(path.newSubPath("offclEcnmcSttstcs"), processor, AssetClassCommodityOfficialEconomicStatistics1.class, getOffclEcnmcSttstcs());
		processRosetta(path.newSubPath("othr"), processor, AssetClassCommodityOther1.class, getOthr());
		processRosetta(path.newSubPath("othrC10"), processor, AssetClassCommodityC10Other1.class, getOthrC10());
		processRosetta(path.newSubPath("ppr"), processor, AssetClassCommodityPaper5Choice.class, getPpr());
		processRosetta(path.newSubPath("plprpln"), processor, AssetClassCommodityPolypropylene4Choice.class, getPlprpln());
	}
	

	/*********************** Builder Interface  ***********************/
	interface AssetClassCommodity7ChoiceBuilder extends AssetClassCommodity7Choice, RosettaModelObjectBuilder {
		AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder getOrCreateAgrcltrl();
		@Override
		AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder getAgrcltrl();
		AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder getOrCreateNrgy();
		@Override
		AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder getNrgy();
		AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder getOrCreateEnvttl();
		@Override
		AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder getEnvttl();
		AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder getOrCreateFrtlzr();
		@Override
		AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder getFrtlzr();
		AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder getOrCreateFrght();
		@Override
		AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder getFrght();
		AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder getOrCreateIndx();
		@Override
		AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder getIndx();
		AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder getOrCreateIndstrlPdct();
		@Override
		AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder getIndstrlPdct();
		AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder getOrCreateInfltn();
		@Override
		AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder getInfltn();
		AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder getOrCreateMetl();
		@Override
		AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder getMetl();
		AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder getOrCreateMultiCmmdtyExtc();
		@Override
		AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder getMultiCmmdtyExtc();
		AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder getOrCreateOffclEcnmcSttstcs();
		@Override
		AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder getOffclEcnmcSttstcs();
		AssetClassCommodityOther1.AssetClassCommodityOther1Builder getOrCreateOthr();
		@Override
		AssetClassCommodityOther1.AssetClassCommodityOther1Builder getOthr();
		AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder getOrCreateOthrC10();
		@Override
		AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder getOthrC10();
		AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder getOrCreatePpr();
		@Override
		AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder getPpr();
		AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder getOrCreatePlprpln();
		@Override
		AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder getPlprpln();
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setAgrcltrl(AssetClassCommodityAgricultural6Choice agrcltrl);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setNrgy(AssetClassCommodityEnergy3Choice nrgy);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setEnvttl(AssetClassCommodityEnvironmental3Choice envttl);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setFrtlzr(AssetClassCommodityFertilizer4Choice frtlzr);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setFrght(AssetClassCommodityFreight4Choice frght);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setIndx(AssetClassCommodityIndex1 indx);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setIndstrlPdct(AssetClassCommodityIndustrialProduct2Choice indstrlPdct);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setInfltn(AssetClassCommodityInflation1 infltn);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setMetl(AssetClassCommodityMetal2Choice metl);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setMultiCmmdtyExtc(AssetClassCommodityMultiCommodityExotic1 multiCmmdtyExtc);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOffclEcnmcSttstcs(AssetClassCommodityOfficialEconomicStatistics1 offclEcnmcSttstcs);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOthr(AssetClassCommodityOther1 othr);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOthrC10(AssetClassCommodityC10Other1 othrC10);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setPpr(AssetClassCommodityPaper5Choice ppr);
		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setPlprpln(AssetClassCommodityPolypropylene4Choice plprpln);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("agrcltrl"), processor, AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder.class, getAgrcltrl());
			processRosetta(path.newSubPath("nrgy"), processor, AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder.class, getNrgy());
			processRosetta(path.newSubPath("envttl"), processor, AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder.class, getEnvttl());
			processRosetta(path.newSubPath("frtlzr"), processor, AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder.class, getFrtlzr());
			processRosetta(path.newSubPath("frght"), processor, AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder.class, getFrght());
			processRosetta(path.newSubPath("indx"), processor, AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder.class, getIndx());
			processRosetta(path.newSubPath("indstrlPdct"), processor, AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder.class, getIndstrlPdct());
			processRosetta(path.newSubPath("infltn"), processor, AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder.class, getInfltn());
			processRosetta(path.newSubPath("metl"), processor, AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder.class, getMetl());
			processRosetta(path.newSubPath("multiCmmdtyExtc"), processor, AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder.class, getMultiCmmdtyExtc());
			processRosetta(path.newSubPath("offclEcnmcSttstcs"), processor, AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder.class, getOffclEcnmcSttstcs());
			processRosetta(path.newSubPath("othr"), processor, AssetClassCommodityOther1.AssetClassCommodityOther1Builder.class, getOthr());
			processRosetta(path.newSubPath("othrC10"), processor, AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder.class, getOthrC10());
			processRosetta(path.newSubPath("ppr"), processor, AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder.class, getPpr());
			processRosetta(path.newSubPath("plprpln"), processor, AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder.class, getPlprpln());
		}
		

		AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder prune();
	}

	/*********************** Immutable Implementation of AssetClassCommodity7Choice  ***********************/
	class AssetClassCommodity7ChoiceImpl implements AssetClassCommodity7Choice {
		private final AssetClassCommodityAgricultural6Choice agrcltrl;
		private final AssetClassCommodityEnergy3Choice nrgy;
		private final AssetClassCommodityEnvironmental3Choice envttl;
		private final AssetClassCommodityFertilizer4Choice frtlzr;
		private final AssetClassCommodityFreight4Choice frght;
		private final AssetClassCommodityIndex1 indx;
		private final AssetClassCommodityIndustrialProduct2Choice indstrlPdct;
		private final AssetClassCommodityInflation1 infltn;
		private final AssetClassCommodityMetal2Choice metl;
		private final AssetClassCommodityMultiCommodityExotic1 multiCmmdtyExtc;
		private final AssetClassCommodityOfficialEconomicStatistics1 offclEcnmcSttstcs;
		private final AssetClassCommodityOther1 othr;
		private final AssetClassCommodityC10Other1 othrC10;
		private final AssetClassCommodityPaper5Choice ppr;
		private final AssetClassCommodityPolypropylene4Choice plprpln;
		
		protected AssetClassCommodity7ChoiceImpl(AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder builder) {
			this.agrcltrl = ofNullable(builder.getAgrcltrl()).map(f->f.build()).orElse(null);
			this.nrgy = ofNullable(builder.getNrgy()).map(f->f.build()).orElse(null);
			this.envttl = ofNullable(builder.getEnvttl()).map(f->f.build()).orElse(null);
			this.frtlzr = ofNullable(builder.getFrtlzr()).map(f->f.build()).orElse(null);
			this.frght = ofNullable(builder.getFrght()).map(f->f.build()).orElse(null);
			this.indx = ofNullable(builder.getIndx()).map(f->f.build()).orElse(null);
			this.indstrlPdct = ofNullable(builder.getIndstrlPdct()).map(f->f.build()).orElse(null);
			this.infltn = ofNullable(builder.getInfltn()).map(f->f.build()).orElse(null);
			this.metl = ofNullable(builder.getMetl()).map(f->f.build()).orElse(null);
			this.multiCmmdtyExtc = ofNullable(builder.getMultiCmmdtyExtc()).map(f->f.build()).orElse(null);
			this.offclEcnmcSttstcs = ofNullable(builder.getOffclEcnmcSttstcs()).map(f->f.build()).orElse(null);
			this.othr = ofNullable(builder.getOthr()).map(f->f.build()).orElse(null);
			this.othrC10 = ofNullable(builder.getOthrC10()).map(f->f.build()).orElse(null);
			this.ppr = ofNullable(builder.getPpr()).map(f->f.build()).orElse(null);
			this.plprpln = ofNullable(builder.getPlprpln()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("agrcltrl")
		@RuneAttribute("agrcltrl")
		public AssetClassCommodityAgricultural6Choice getAgrcltrl() {
			return agrcltrl;
		}
		
		@Override
		@RosettaAttribute("nrgy")
		@RuneAttribute("nrgy")
		public AssetClassCommodityEnergy3Choice getNrgy() {
			return nrgy;
		}
		
		@Override
		@RosettaAttribute("envttl")
		@RuneAttribute("envttl")
		public AssetClassCommodityEnvironmental3Choice getEnvttl() {
			return envttl;
		}
		
		@Override
		@RosettaAttribute("frtlzr")
		@RuneAttribute("frtlzr")
		public AssetClassCommodityFertilizer4Choice getFrtlzr() {
			return frtlzr;
		}
		
		@Override
		@RosettaAttribute("frght")
		@RuneAttribute("frght")
		public AssetClassCommodityFreight4Choice getFrght() {
			return frght;
		}
		
		@Override
		@RosettaAttribute("indx")
		@RuneAttribute("indx")
		public AssetClassCommodityIndex1 getIndx() {
			return indx;
		}
		
		@Override
		@RosettaAttribute("indstrlPdct")
		@RuneAttribute("indstrlPdct")
		public AssetClassCommodityIndustrialProduct2Choice getIndstrlPdct() {
			return indstrlPdct;
		}
		
		@Override
		@RosettaAttribute("infltn")
		@RuneAttribute("infltn")
		public AssetClassCommodityInflation1 getInfltn() {
			return infltn;
		}
		
		@Override
		@RosettaAttribute("metl")
		@RuneAttribute("metl")
		public AssetClassCommodityMetal2Choice getMetl() {
			return metl;
		}
		
		@Override
		@RosettaAttribute("multiCmmdtyExtc")
		@RuneAttribute("multiCmmdtyExtc")
		public AssetClassCommodityMultiCommodityExotic1 getMultiCmmdtyExtc() {
			return multiCmmdtyExtc;
		}
		
		@Override
		@RosettaAttribute("offclEcnmcSttstcs")
		@RuneAttribute("offclEcnmcSttstcs")
		public AssetClassCommodityOfficialEconomicStatistics1 getOffclEcnmcSttstcs() {
			return offclEcnmcSttstcs;
		}
		
		@Override
		@RosettaAttribute("othr")
		@RuneAttribute("othr")
		public AssetClassCommodityOther1 getOthr() {
			return othr;
		}
		
		@Override
		@RosettaAttribute("othrC10")
		@RuneAttribute("othrC10")
		public AssetClassCommodityC10Other1 getOthrC10() {
			return othrC10;
		}
		
		@Override
		@RosettaAttribute("ppr")
		@RuneAttribute("ppr")
		public AssetClassCommodityPaper5Choice getPpr() {
			return ppr;
		}
		
		@Override
		@RosettaAttribute("plprpln")
		@RuneAttribute("plprpln")
		public AssetClassCommodityPolypropylene4Choice getPlprpln() {
			return plprpln;
		}
		
		@Override
		public AssetClassCommodity7Choice build() {
			return this;
		}
		
		@Override
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder toBuilder() {
			AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder builder) {
			ofNullable(getAgrcltrl()).ifPresent(builder::setAgrcltrl);
			ofNullable(getNrgy()).ifPresent(builder::setNrgy);
			ofNullable(getEnvttl()).ifPresent(builder::setEnvttl);
			ofNullable(getFrtlzr()).ifPresent(builder::setFrtlzr);
			ofNullable(getFrght()).ifPresent(builder::setFrght);
			ofNullable(getIndx()).ifPresent(builder::setIndx);
			ofNullable(getIndstrlPdct()).ifPresent(builder::setIndstrlPdct);
			ofNullable(getInfltn()).ifPresent(builder::setInfltn);
			ofNullable(getMetl()).ifPresent(builder::setMetl);
			ofNullable(getMultiCmmdtyExtc()).ifPresent(builder::setMultiCmmdtyExtc);
			ofNullable(getOffclEcnmcSttstcs()).ifPresent(builder::setOffclEcnmcSttstcs);
			ofNullable(getOthr()).ifPresent(builder::setOthr);
			ofNullable(getOthrC10()).ifPresent(builder::setOthrC10);
			ofNullable(getPpr()).ifPresent(builder::setPpr);
			ofNullable(getPlprpln()).ifPresent(builder::setPlprpln);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AssetClassCommodity7Choice _that = getType().cast(o);
		
			if (!Objects.equals(agrcltrl, _that.getAgrcltrl())) return false;
			if (!Objects.equals(nrgy, _that.getNrgy())) return false;
			if (!Objects.equals(envttl, _that.getEnvttl())) return false;
			if (!Objects.equals(frtlzr, _that.getFrtlzr())) return false;
			if (!Objects.equals(frght, _that.getFrght())) return false;
			if (!Objects.equals(indx, _that.getIndx())) return false;
			if (!Objects.equals(indstrlPdct, _that.getIndstrlPdct())) return false;
			if (!Objects.equals(infltn, _that.getInfltn())) return false;
			if (!Objects.equals(metl, _that.getMetl())) return false;
			if (!Objects.equals(multiCmmdtyExtc, _that.getMultiCmmdtyExtc())) return false;
			if (!Objects.equals(offclEcnmcSttstcs, _that.getOffclEcnmcSttstcs())) return false;
			if (!Objects.equals(othr, _that.getOthr())) return false;
			if (!Objects.equals(othrC10, _that.getOthrC10())) return false;
			if (!Objects.equals(ppr, _that.getPpr())) return false;
			if (!Objects.equals(plprpln, _that.getPlprpln())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (agrcltrl != null ? agrcltrl.hashCode() : 0);
			_result = 31 * _result + (nrgy != null ? nrgy.hashCode() : 0);
			_result = 31 * _result + (envttl != null ? envttl.hashCode() : 0);
			_result = 31 * _result + (frtlzr != null ? frtlzr.hashCode() : 0);
			_result = 31 * _result + (frght != null ? frght.hashCode() : 0);
			_result = 31 * _result + (indx != null ? indx.hashCode() : 0);
			_result = 31 * _result + (indstrlPdct != null ? indstrlPdct.hashCode() : 0);
			_result = 31 * _result + (infltn != null ? infltn.hashCode() : 0);
			_result = 31 * _result + (metl != null ? metl.hashCode() : 0);
			_result = 31 * _result + (multiCmmdtyExtc != null ? multiCmmdtyExtc.hashCode() : 0);
			_result = 31 * _result + (offclEcnmcSttstcs != null ? offclEcnmcSttstcs.hashCode() : 0);
			_result = 31 * _result + (othr != null ? othr.hashCode() : 0);
			_result = 31 * _result + (othrC10 != null ? othrC10.hashCode() : 0);
			_result = 31 * _result + (ppr != null ? ppr.hashCode() : 0);
			_result = 31 * _result + (plprpln != null ? plprpln.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AssetClassCommodity7Choice {" +
				"agrcltrl=" + this.agrcltrl + ", " +
				"nrgy=" + this.nrgy + ", " +
				"envttl=" + this.envttl + ", " +
				"frtlzr=" + this.frtlzr + ", " +
				"frght=" + this.frght + ", " +
				"indx=" + this.indx + ", " +
				"indstrlPdct=" + this.indstrlPdct + ", " +
				"infltn=" + this.infltn + ", " +
				"metl=" + this.metl + ", " +
				"multiCmmdtyExtc=" + this.multiCmmdtyExtc + ", " +
				"offclEcnmcSttstcs=" + this.offclEcnmcSttstcs + ", " +
				"othr=" + this.othr + ", " +
				"othrC10=" + this.othrC10 + ", " +
				"ppr=" + this.ppr + ", " +
				"plprpln=" + this.plprpln +
			'}';
		}
	}

	/*********************** Builder Implementation of AssetClassCommodity7Choice  ***********************/
	class AssetClassCommodity7ChoiceBuilderImpl implements AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder {
	
		protected AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder agrcltrl;
		protected AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder nrgy;
		protected AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder envttl;
		protected AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder frtlzr;
		protected AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder frght;
		protected AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder indx;
		protected AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder indstrlPdct;
		protected AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder infltn;
		protected AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder metl;
		protected AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder multiCmmdtyExtc;
		protected AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder offclEcnmcSttstcs;
		protected AssetClassCommodityOther1.AssetClassCommodityOther1Builder othr;
		protected AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder othrC10;
		protected AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder ppr;
		protected AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder plprpln;
		
		@Override
		@RosettaAttribute("agrcltrl")
		@RuneAttribute("agrcltrl")
		public AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder getAgrcltrl() {
			return agrcltrl;
		}
		
		@Override
		public AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder getOrCreateAgrcltrl() {
			AssetClassCommodityAgricultural6Choice.AssetClassCommodityAgricultural6ChoiceBuilder result;
			if (agrcltrl!=null) {
				result = agrcltrl;
			}
			else {
				result = agrcltrl = AssetClassCommodityAgricultural6Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("nrgy")
		@RuneAttribute("nrgy")
		public AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder getNrgy() {
			return nrgy;
		}
		
		@Override
		public AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder getOrCreateNrgy() {
			AssetClassCommodityEnergy3Choice.AssetClassCommodityEnergy3ChoiceBuilder result;
			if (nrgy!=null) {
				result = nrgy;
			}
			else {
				result = nrgy = AssetClassCommodityEnergy3Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("envttl")
		@RuneAttribute("envttl")
		public AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder getEnvttl() {
			return envttl;
		}
		
		@Override
		public AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder getOrCreateEnvttl() {
			AssetClassCommodityEnvironmental3Choice.AssetClassCommodityEnvironmental3ChoiceBuilder result;
			if (envttl!=null) {
				result = envttl;
			}
			else {
				result = envttl = AssetClassCommodityEnvironmental3Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("frtlzr")
		@RuneAttribute("frtlzr")
		public AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder getFrtlzr() {
			return frtlzr;
		}
		
		@Override
		public AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder getOrCreateFrtlzr() {
			AssetClassCommodityFertilizer4Choice.AssetClassCommodityFertilizer4ChoiceBuilder result;
			if (frtlzr!=null) {
				result = frtlzr;
			}
			else {
				result = frtlzr = AssetClassCommodityFertilizer4Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("frght")
		@RuneAttribute("frght")
		public AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder getFrght() {
			return frght;
		}
		
		@Override
		public AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder getOrCreateFrght() {
			AssetClassCommodityFreight4Choice.AssetClassCommodityFreight4ChoiceBuilder result;
			if (frght!=null) {
				result = frght;
			}
			else {
				result = frght = AssetClassCommodityFreight4Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("indx")
		@RuneAttribute("indx")
		public AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder getIndx() {
			return indx;
		}
		
		@Override
		public AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder getOrCreateIndx() {
			AssetClassCommodityIndex1.AssetClassCommodityIndex1Builder result;
			if (indx!=null) {
				result = indx;
			}
			else {
				result = indx = AssetClassCommodityIndex1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("indstrlPdct")
		@RuneAttribute("indstrlPdct")
		public AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder getIndstrlPdct() {
			return indstrlPdct;
		}
		
		@Override
		public AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder getOrCreateIndstrlPdct() {
			AssetClassCommodityIndustrialProduct2Choice.AssetClassCommodityIndustrialProduct2ChoiceBuilder result;
			if (indstrlPdct!=null) {
				result = indstrlPdct;
			}
			else {
				result = indstrlPdct = AssetClassCommodityIndustrialProduct2Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("infltn")
		@RuneAttribute("infltn")
		public AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder getInfltn() {
			return infltn;
		}
		
		@Override
		public AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder getOrCreateInfltn() {
			AssetClassCommodityInflation1.AssetClassCommodityInflation1Builder result;
			if (infltn!=null) {
				result = infltn;
			}
			else {
				result = infltn = AssetClassCommodityInflation1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("metl")
		@RuneAttribute("metl")
		public AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder getMetl() {
			return metl;
		}
		
		@Override
		public AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder getOrCreateMetl() {
			AssetClassCommodityMetal2Choice.AssetClassCommodityMetal2ChoiceBuilder result;
			if (metl!=null) {
				result = metl;
			}
			else {
				result = metl = AssetClassCommodityMetal2Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("multiCmmdtyExtc")
		@RuneAttribute("multiCmmdtyExtc")
		public AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder getMultiCmmdtyExtc() {
			return multiCmmdtyExtc;
		}
		
		@Override
		public AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder getOrCreateMultiCmmdtyExtc() {
			AssetClassCommodityMultiCommodityExotic1.AssetClassCommodityMultiCommodityExotic1Builder result;
			if (multiCmmdtyExtc!=null) {
				result = multiCmmdtyExtc;
			}
			else {
				result = multiCmmdtyExtc = AssetClassCommodityMultiCommodityExotic1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("offclEcnmcSttstcs")
		@RuneAttribute("offclEcnmcSttstcs")
		public AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder getOffclEcnmcSttstcs() {
			return offclEcnmcSttstcs;
		}
		
		@Override
		public AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder getOrCreateOffclEcnmcSttstcs() {
			AssetClassCommodityOfficialEconomicStatistics1.AssetClassCommodityOfficialEconomicStatistics1Builder result;
			if (offclEcnmcSttstcs!=null) {
				result = offclEcnmcSttstcs;
			}
			else {
				result = offclEcnmcSttstcs = AssetClassCommodityOfficialEconomicStatistics1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("othr")
		@RuneAttribute("othr")
		public AssetClassCommodityOther1.AssetClassCommodityOther1Builder getOthr() {
			return othr;
		}
		
		@Override
		public AssetClassCommodityOther1.AssetClassCommodityOther1Builder getOrCreateOthr() {
			AssetClassCommodityOther1.AssetClassCommodityOther1Builder result;
			if (othr!=null) {
				result = othr;
			}
			else {
				result = othr = AssetClassCommodityOther1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("othrC10")
		@RuneAttribute("othrC10")
		public AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder getOthrC10() {
			return othrC10;
		}
		
		@Override
		public AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder getOrCreateOthrC10() {
			AssetClassCommodityC10Other1.AssetClassCommodityC10Other1Builder result;
			if (othrC10!=null) {
				result = othrC10;
			}
			else {
				result = othrC10 = AssetClassCommodityC10Other1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ppr")
		@RuneAttribute("ppr")
		public AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder getPpr() {
			return ppr;
		}
		
		@Override
		public AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder getOrCreatePpr() {
			AssetClassCommodityPaper5Choice.AssetClassCommodityPaper5ChoiceBuilder result;
			if (ppr!=null) {
				result = ppr;
			}
			else {
				result = ppr = AssetClassCommodityPaper5Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("plprpln")
		@RuneAttribute("plprpln")
		public AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder getPlprpln() {
			return plprpln;
		}
		
		@Override
		public AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder getOrCreatePlprpln() {
			AssetClassCommodityPolypropylene4Choice.AssetClassCommodityPolypropylene4ChoiceBuilder result;
			if (plprpln!=null) {
				result = plprpln;
			}
			else {
				result = plprpln = AssetClassCommodityPolypropylene4Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("agrcltrl")
		@RuneAttribute("agrcltrl")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setAgrcltrl(AssetClassCommodityAgricultural6Choice _agrcltrl) {
			this.agrcltrl = _agrcltrl == null ? null : _agrcltrl.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("nrgy")
		@RuneAttribute("nrgy")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setNrgy(AssetClassCommodityEnergy3Choice _nrgy) {
			this.nrgy = _nrgy == null ? null : _nrgy.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("envttl")
		@RuneAttribute("envttl")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setEnvttl(AssetClassCommodityEnvironmental3Choice _envttl) {
			this.envttl = _envttl == null ? null : _envttl.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("frtlzr")
		@RuneAttribute("frtlzr")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setFrtlzr(AssetClassCommodityFertilizer4Choice _frtlzr) {
			this.frtlzr = _frtlzr == null ? null : _frtlzr.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("frght")
		@RuneAttribute("frght")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setFrght(AssetClassCommodityFreight4Choice _frght) {
			this.frght = _frght == null ? null : _frght.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("indx")
		@RuneAttribute("indx")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setIndx(AssetClassCommodityIndex1 _indx) {
			this.indx = _indx == null ? null : _indx.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("indstrlPdct")
		@RuneAttribute("indstrlPdct")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setIndstrlPdct(AssetClassCommodityIndustrialProduct2Choice _indstrlPdct) {
			this.indstrlPdct = _indstrlPdct == null ? null : _indstrlPdct.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("infltn")
		@RuneAttribute("infltn")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setInfltn(AssetClassCommodityInflation1 _infltn) {
			this.infltn = _infltn == null ? null : _infltn.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("metl")
		@RuneAttribute("metl")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setMetl(AssetClassCommodityMetal2Choice _metl) {
			this.metl = _metl == null ? null : _metl.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("multiCmmdtyExtc")
		@RuneAttribute("multiCmmdtyExtc")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setMultiCmmdtyExtc(AssetClassCommodityMultiCommodityExotic1 _multiCmmdtyExtc) {
			this.multiCmmdtyExtc = _multiCmmdtyExtc == null ? null : _multiCmmdtyExtc.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("offclEcnmcSttstcs")
		@RuneAttribute("offclEcnmcSttstcs")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOffclEcnmcSttstcs(AssetClassCommodityOfficialEconomicStatistics1 _offclEcnmcSttstcs) {
			this.offclEcnmcSttstcs = _offclEcnmcSttstcs == null ? null : _offclEcnmcSttstcs.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("othr")
		@RuneAttribute("othr")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOthr(AssetClassCommodityOther1 _othr) {
			this.othr = _othr == null ? null : _othr.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("othrC10")
		@RuneAttribute("othrC10")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setOthrC10(AssetClassCommodityC10Other1 _othrC10) {
			this.othrC10 = _othrC10 == null ? null : _othrC10.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("ppr")
		@RuneAttribute("ppr")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setPpr(AssetClassCommodityPaper5Choice _ppr) {
			this.ppr = _ppr == null ? null : _ppr.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("plprpln")
		@RuneAttribute("plprpln")
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder setPlprpln(AssetClassCommodityPolypropylene4Choice _plprpln) {
			this.plprpln = _plprpln == null ? null : _plprpln.toBuilder();
			return this;
		}
		
		@Override
		public AssetClassCommodity7Choice build() {
			return new AssetClassCommodity7Choice.AssetClassCommodity7ChoiceImpl(this);
		}
		
		@Override
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder prune() {
			if (agrcltrl!=null && !agrcltrl.prune().hasData()) agrcltrl = null;
			if (nrgy!=null && !nrgy.prune().hasData()) nrgy = null;
			if (envttl!=null && !envttl.prune().hasData()) envttl = null;
			if (frtlzr!=null && !frtlzr.prune().hasData()) frtlzr = null;
			if (frght!=null && !frght.prune().hasData()) frght = null;
			if (indx!=null && !indx.prune().hasData()) indx = null;
			if (indstrlPdct!=null && !indstrlPdct.prune().hasData()) indstrlPdct = null;
			if (infltn!=null && !infltn.prune().hasData()) infltn = null;
			if (metl!=null && !metl.prune().hasData()) metl = null;
			if (multiCmmdtyExtc!=null && !multiCmmdtyExtc.prune().hasData()) multiCmmdtyExtc = null;
			if (offclEcnmcSttstcs!=null && !offclEcnmcSttstcs.prune().hasData()) offclEcnmcSttstcs = null;
			if (othr!=null && !othr.prune().hasData()) othr = null;
			if (othrC10!=null && !othrC10.prune().hasData()) othrC10 = null;
			if (ppr!=null && !ppr.prune().hasData()) ppr = null;
			if (plprpln!=null && !plprpln.prune().hasData()) plprpln = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAgrcltrl()!=null && getAgrcltrl().hasData()) return true;
			if (getNrgy()!=null && getNrgy().hasData()) return true;
			if (getEnvttl()!=null && getEnvttl().hasData()) return true;
			if (getFrtlzr()!=null && getFrtlzr().hasData()) return true;
			if (getFrght()!=null && getFrght().hasData()) return true;
			if (getIndx()!=null && getIndx().hasData()) return true;
			if (getIndstrlPdct()!=null && getIndstrlPdct().hasData()) return true;
			if (getInfltn()!=null && getInfltn().hasData()) return true;
			if (getMetl()!=null && getMetl().hasData()) return true;
			if (getMultiCmmdtyExtc()!=null && getMultiCmmdtyExtc().hasData()) return true;
			if (getOffclEcnmcSttstcs()!=null && getOffclEcnmcSttstcs().hasData()) return true;
			if (getOthr()!=null && getOthr().hasData()) return true;
			if (getOthrC10()!=null && getOthrC10().hasData()) return true;
			if (getPpr()!=null && getPpr().hasData()) return true;
			if (getPlprpln()!=null && getPlprpln().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder o = (AssetClassCommodity7Choice.AssetClassCommodity7ChoiceBuilder) other;
			
			merger.mergeRosetta(getAgrcltrl(), o.getAgrcltrl(), this::setAgrcltrl);
			merger.mergeRosetta(getNrgy(), o.getNrgy(), this::setNrgy);
			merger.mergeRosetta(getEnvttl(), o.getEnvttl(), this::setEnvttl);
			merger.mergeRosetta(getFrtlzr(), o.getFrtlzr(), this::setFrtlzr);
			merger.mergeRosetta(getFrght(), o.getFrght(), this::setFrght);
			merger.mergeRosetta(getIndx(), o.getIndx(), this::setIndx);
			merger.mergeRosetta(getIndstrlPdct(), o.getIndstrlPdct(), this::setIndstrlPdct);
			merger.mergeRosetta(getInfltn(), o.getInfltn(), this::setInfltn);
			merger.mergeRosetta(getMetl(), o.getMetl(), this::setMetl);
			merger.mergeRosetta(getMultiCmmdtyExtc(), o.getMultiCmmdtyExtc(), this::setMultiCmmdtyExtc);
			merger.mergeRosetta(getOffclEcnmcSttstcs(), o.getOffclEcnmcSttstcs(), this::setOffclEcnmcSttstcs);
			merger.mergeRosetta(getOthr(), o.getOthr(), this::setOthr);
			merger.mergeRosetta(getOthrC10(), o.getOthrC10(), this::setOthrC10);
			merger.mergeRosetta(getPpr(), o.getPpr(), this::setPpr);
			merger.mergeRosetta(getPlprpln(), o.getPlprpln(), this::setPlprpln);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AssetClassCommodity7Choice _that = getType().cast(o);
		
			if (!Objects.equals(agrcltrl, _that.getAgrcltrl())) return false;
			if (!Objects.equals(nrgy, _that.getNrgy())) return false;
			if (!Objects.equals(envttl, _that.getEnvttl())) return false;
			if (!Objects.equals(frtlzr, _that.getFrtlzr())) return false;
			if (!Objects.equals(frght, _that.getFrght())) return false;
			if (!Objects.equals(indx, _that.getIndx())) return false;
			if (!Objects.equals(indstrlPdct, _that.getIndstrlPdct())) return false;
			if (!Objects.equals(infltn, _that.getInfltn())) return false;
			if (!Objects.equals(metl, _that.getMetl())) return false;
			if (!Objects.equals(multiCmmdtyExtc, _that.getMultiCmmdtyExtc())) return false;
			if (!Objects.equals(offclEcnmcSttstcs, _that.getOffclEcnmcSttstcs())) return false;
			if (!Objects.equals(othr, _that.getOthr())) return false;
			if (!Objects.equals(othrC10, _that.getOthrC10())) return false;
			if (!Objects.equals(ppr, _that.getPpr())) return false;
			if (!Objects.equals(plprpln, _that.getPlprpln())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (agrcltrl != null ? agrcltrl.hashCode() : 0);
			_result = 31 * _result + (nrgy != null ? nrgy.hashCode() : 0);
			_result = 31 * _result + (envttl != null ? envttl.hashCode() : 0);
			_result = 31 * _result + (frtlzr != null ? frtlzr.hashCode() : 0);
			_result = 31 * _result + (frght != null ? frght.hashCode() : 0);
			_result = 31 * _result + (indx != null ? indx.hashCode() : 0);
			_result = 31 * _result + (indstrlPdct != null ? indstrlPdct.hashCode() : 0);
			_result = 31 * _result + (infltn != null ? infltn.hashCode() : 0);
			_result = 31 * _result + (metl != null ? metl.hashCode() : 0);
			_result = 31 * _result + (multiCmmdtyExtc != null ? multiCmmdtyExtc.hashCode() : 0);
			_result = 31 * _result + (offclEcnmcSttstcs != null ? offclEcnmcSttstcs.hashCode() : 0);
			_result = 31 * _result + (othr != null ? othr.hashCode() : 0);
			_result = 31 * _result + (othrC10 != null ? othrC10.hashCode() : 0);
			_result = 31 * _result + (ppr != null ? ppr.hashCode() : 0);
			_result = 31 * _result + (plprpln != null ? plprpln.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AssetClassCommodity7ChoiceBuilder {" +
				"agrcltrl=" + this.agrcltrl + ", " +
				"nrgy=" + this.nrgy + ", " +
				"envttl=" + this.envttl + ", " +
				"frtlzr=" + this.frtlzr + ", " +
				"frght=" + this.frght + ", " +
				"indx=" + this.indx + ", " +
				"indstrlPdct=" + this.indstrlPdct + ", " +
				"infltn=" + this.infltn + ", " +
				"metl=" + this.metl + ", " +
				"multiCmmdtyExtc=" + this.multiCmmdtyExtc + ", " +
				"offclEcnmcSttstcs=" + this.offclEcnmcSttstcs + ", " +
				"othr=" + this.othr + ", " +
				"othrC10=" + this.othrC10 + ", " +
				"ppr=" + this.ppr + ", " +
				"plprpln=" + this.plprpln +
			'}';
		}
	}
}
