package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import iso20022.auth030.hkma.dtcc.AssetClassProductType1Code;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * Commodity derivative base product code list for Agricultural.
 * @version 1.22.0
 */
@RosettaEnum("AssetClassProductType1Code")
public enum AssetClassProductType1Code {

	/**
	 * Commodity of type agricultural.
	 */
	@RosettaEnumValue(value = "AGRI") 
	AGRI("AGRI", null)
;
	private static Map<String, AssetClassProductType1Code> values;
	static {
        Map<String, AssetClassProductType1Code> map = new ConcurrentHashMap<>();
		for (AssetClassProductType1Code instance : AssetClassProductType1Code.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	AssetClassProductType1Code(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static AssetClassProductType1Code fromDisplayName(String name) {
		AssetClassProductType1Code value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
