package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.ContractValuationData8__1;
import iso20022.auth030.hkma.dtcc.ContractValuationData8__1.ContractValuationData8__1Builder;
import iso20022.auth030.hkma.dtcc.CounterpartySpecificData36__3;
import iso20022.auth030.hkma.dtcc.CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder;
import iso20022.auth030.hkma.dtcc.CounterpartySpecificData36__3.CounterpartySpecificData36__3BuilderImpl;
import iso20022.auth030.hkma.dtcc.CounterpartySpecificData36__3.CounterpartySpecificData36__3Impl;
import iso20022.auth030.hkma.dtcc.TradeCounterpartyReport20__2;
import iso20022.auth030.hkma.dtcc.TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder;
import iso20022.auth030.hkma.dtcc.meta.CounterpartySpecificData36__3Meta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Data related specifically to counterparties.
 * @version 1.22.0
 */
@RosettaDataType(value="CounterpartySpecificData36__3", builder=CounterpartySpecificData36__3.CounterpartySpecificData36__3BuilderImpl.class, version="1.22.0")
@RuneDataType(value="CounterpartySpecificData36__3", model="iso20022", builder=CounterpartySpecificData36__3.CounterpartySpecificData36__3BuilderImpl.class, version="1.22.0")
public interface CounterpartySpecificData36__3 extends RosettaModelObject {

	CounterpartySpecificData36__3Meta metaData = new CounterpartySpecificData36__3Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Data specific to counterparties of the reported transaction/position.
	 */
	TradeCounterpartyReport20__2 getCtrPty();
	/**
	 * Data specific to the valuation of the transaction.
	 */
	ContractValuationData8__1 getValtn();
	/**
	 * Indicates the date and time of the submission of the report to the trade repository.
	 */
	ZonedDateTime getRptgTmStmp();

	/*********************** Build Methods  ***********************/
	CounterpartySpecificData36__3 build();
	
	CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder toBuilder();
	
	static CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder builder() {
		return new CounterpartySpecificData36__3.CounterpartySpecificData36__3BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CounterpartySpecificData36__3> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CounterpartySpecificData36__3> getType() {
		return CounterpartySpecificData36__3.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__2.class, getCtrPty());
		processRosetta(path.newSubPath("valtn"), processor, ContractValuationData8__1.class, getValtn());
		processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CounterpartySpecificData36__3Builder extends CounterpartySpecificData36__3, RosettaModelObjectBuilder {
		TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getOrCreateCtrPty();
		@Override
		TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getCtrPty();
		ContractValuationData8__1.ContractValuationData8__1Builder getOrCreateValtn();
		@Override
		ContractValuationData8__1.ContractValuationData8__1Builder getValtn();
		CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setCtrPty(TradeCounterpartyReport20__2 ctrPty);
		CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setValtn(ContractValuationData8__1 valtn);
		CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setRptgTmStmp(ZonedDateTime rptgTmStmp);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder.class, getCtrPty());
			processRosetta(path.newSubPath("valtn"), processor, ContractValuationData8__1.ContractValuationData8__1Builder.class, getValtn());
			processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
		}
		

		CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder prune();
	}

	/*********************** Immutable Implementation of CounterpartySpecificData36__3  ***********************/
	class CounterpartySpecificData36__3Impl implements CounterpartySpecificData36__3 {
		private final TradeCounterpartyReport20__2 ctrPty;
		private final ContractValuationData8__1 valtn;
		private final ZonedDateTime rptgTmStmp;
		
		protected CounterpartySpecificData36__3Impl(CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder builder) {
			this.ctrPty = ofNullable(builder.getCtrPty()).map(f->f.build()).orElse(null);
			this.valtn = ofNullable(builder.getValtn()).map(f->f.build()).orElse(null);
			this.rptgTmStmp = builder.getRptgTmStmp();
		}
		
		@Override
		@RosettaAttribute("ctrPty")
		@RuneAttribute("ctrPty")
		public TradeCounterpartyReport20__2 getCtrPty() {
			return ctrPty;
		}
		
		@Override
		@RosettaAttribute("valtn")
		@RuneAttribute("valtn")
		public ContractValuationData8__1 getValtn() {
			return valtn;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@Override
		public CounterpartySpecificData36__3 build() {
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder toBuilder() {
			CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder builder) {
			ofNullable(getCtrPty()).ifPresent(builder::setCtrPty);
			ofNullable(getValtn()).ifPresent(builder::setValtn);
			ofNullable(getRptgTmStmp()).ifPresent(builder::setRptgTmStmp);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__3 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(valtn, _that.getValtn())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (valtn != null ? valtn.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__3 {" +
				"ctrPty=" + this.ctrPty + ", " +
				"valtn=" + this.valtn + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}

	/*********************** Builder Implementation of CounterpartySpecificData36__3  ***********************/
	class CounterpartySpecificData36__3BuilderImpl implements CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder {
	
		protected TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder ctrPty;
		protected ContractValuationData8__1.ContractValuationData8__1Builder valtn;
		protected ZonedDateTime rptgTmStmp;
		
		@Override
		@RosettaAttribute("ctrPty")
		@RuneAttribute("ctrPty")
		public TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getCtrPty() {
			return ctrPty;
		}
		
		@Override
		public TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getOrCreateCtrPty() {
			TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder result;
			if (ctrPty!=null) {
				result = ctrPty;
			}
			else {
				result = ctrPty = TradeCounterpartyReport20__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("valtn")
		@RuneAttribute("valtn")
		public ContractValuationData8__1.ContractValuationData8__1Builder getValtn() {
			return valtn;
		}
		
		@Override
		public ContractValuationData8__1.ContractValuationData8__1Builder getOrCreateValtn() {
			ContractValuationData8__1.ContractValuationData8__1Builder result;
			if (valtn!=null) {
				result = valtn;
			}
			else {
				result = valtn = ContractValuationData8__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@Override
		@RosettaAttribute("ctrPty")
		@RuneAttribute("ctrPty")
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setCtrPty(TradeCounterpartyReport20__2 _ctrPty) {
			this.ctrPty = _ctrPty == null ? null : _ctrPty.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("valtn")
		@RuneAttribute("valtn")
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setValtn(ContractValuationData8__1 _valtn) {
			this.valtn = _valtn == null ? null : _valtn.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder setRptgTmStmp(ZonedDateTime _rptgTmStmp) {
			this.rptgTmStmp = _rptgTmStmp == null ? null : _rptgTmStmp;
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__3 build() {
			return new CounterpartySpecificData36__3.CounterpartySpecificData36__3Impl(this);
		}
		
		@Override
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder prune() {
			if (ctrPty!=null && !ctrPty.prune().hasData()) ctrPty = null;
			if (valtn!=null && !valtn.prune().hasData()) valtn = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrPty()!=null && getCtrPty().hasData()) return true;
			if (getValtn()!=null && getValtn().hasData()) return true;
			if (getRptgTmStmp()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder o = (CounterpartySpecificData36__3.CounterpartySpecificData36__3Builder) other;
			
			merger.mergeRosetta(getCtrPty(), o.getCtrPty(), this::setCtrPty);
			merger.mergeRosetta(getValtn(), o.getValtn(), this::setValtn);
			
			merger.mergeBasic(getRptgTmStmp(), o.getRptgTmStmp(), this::setRptgTmStmp);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__3 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(valtn, _that.getValtn())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (valtn != null ? valtn.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__3Builder {" +
				"ctrPty=" + this.ctrPty + ", " +
				"valtn=" + this.valtn + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}
}
